/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import net.sf.ehcache.CacheManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.CoreStatus;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.util.SolrVersion;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.http.HTTPRepository;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.repository.sparql.SPARQLRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.binary.BinaryRDFWriterFactory;
import org.eclipse.rdf4j.rio.nquads.NQuadsWriterFactory;
import org.eclipse.rdf4j.rio.trig.TriGWriterFactory;
import org.eclipse.rdf4j.rio.trix.TriXWriterFactory;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.lmdb.LmdbStore;
import org.eclipse.rdf4j.sail.lmdb.config.LmdbStoreConfig;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import org.entrystore.ContextManager;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.PrincipalManager;
import org.entrystore.SearchIndex;
import org.entrystore.config.Config;
import org.entrystore.impl.ContextManagerImpl;
import org.entrystore.impl.PrincipalManagerImpl;
import org.entrystore.impl.PublicRepository;
import org.entrystore.impl.RegularContext;
import org.entrystore.impl.SoftCache;
import org.entrystore.impl.converters.ConverterUtil;
import org.entrystore.repository.RepositoryEvent;
import org.entrystore.repository.RepositoryEventObject;
import org.entrystore.repository.RepositoryListener;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.ConfigurationManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.util.DataCorrection;
import org.entrystore.repository.util.FileOperations;
import org.entrystore.repository.util.NS;
import org.entrystore.repository.util.SolrSearchIndex;
import org.entrystore.repository.util.StringUtils;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryManagerImpl
implements RepositoryManager {
    private static final Logger log = LoggerFactory.getLogger(RepositoryManagerImpl.class);
    private Repository repository;
    private ContextManagerImpl contextManager;
    private PrincipalManager principalManager;
    private URL baseURL;
    private boolean checkForAuthorization = true;
    private final ArrayList<String> systemContextAliasList = new ArrayList();
    private static final Map<String, RepositoryManagerImpl> instances = Collections.synchronizedMap(new HashMap());
    private final Map<String, Class> alias2Class = new HashMap<String, Class>();
    private boolean modificationLockout = false;
    private boolean shutdown = false;
    private final Object mutex = new Object();
    private final SoftCache softCache;
    private final Config configuration;
    private CacheManager cacheManager;
    private final boolean quotaEnabled;
    private long defaultQuota = -1L;
    private long maximumFileSize = -1L;
    private final Map<RepositoryEvent, Set<RepositoryListener>> repositoryListeners = new EnumMap<RepositoryEvent, Set<RepositoryListener>>(RepositoryEvent.class);
    private SolrClient solrServer;
    private SolrSearchIndex solrIndex;
    private PublicRepository publicRepository;
    private Repository provenanceRepository;
    static boolean trackDeletedEntries;
    private static String VERSION;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryManagerImpl(String baseURL, Config configuration) {
        System.setProperty("org.openrdf.repository.debug", "true");
        this.configuration = configuration;
        String storeType = configuration.getString(Settings.STORE_TYPE, "memory").trim();
        log.info("Store type: {}", (Object)storeType);
        if (storeType.equalsIgnoreCase("memory")) {
            log.info("Using Memory Store");
            if (configuration.containsKey(Settings.STORE_PATH)) {
                MemoryStore ms = new MemoryStore(new File(configuration.getURI(Settings.STORE_PATH)));
                ms.setPersist(true);
                ms.setSyncDelay(5000L);
                this.repository = new SailRepository((Sail)ms);
            } else {
                this.repository = new SailRepository((Sail)new MemoryStore());
            }
        } else if (storeType.equalsIgnoreCase("native")) {
            if (!configuration.containsKey(Settings.STORE_PATH)) {
                log.error("Incomplete configuration for Native store");
                throw new IllegalStateException("Incomplete configuration");
            }
            path = new File(configuration.getURI(Settings.STORE_PATH));
            indexes = configuration.getString(Settings.STORE_INDEXES);
            this.checkAndUpgradeNativeStore(path, indexes);
            log.info("Main repository: using Native Store at {} with indexes {}", (Object)path, (Object)indexes);
            NativeStore store = indexes != null ? new NativeStore(path, indexes) : new NativeStore(path);
            this.repository = new SailRepository((Sail)store);
        } else if (storeType.equalsIgnoreCase("http")) {
            if (!configuration.containsKey(Settings.STORE_URL)) {
                log.error("Incomplete configuration for HTTP store");
                throw new IllegalStateException("Incomplete configuration");
            }
            String url = configuration.getString(Settings.STORE_URL);
            String user = configuration.getString(Settings.STORE_USER);
            String password = configuration.getString(Settings.STORE_PWD);
            log.info("Using HTTP repository at {}", (Object)url);
            this.repository = new HTTPRepository(url);
            if (user != null && password != null) {
                ((HTTPRepository)this.repository).setUsernameAndPassword(user, password);
            }
        } else if (storeType.equalsIgnoreCase("sparql")) {
            if (!configuration.containsKey(Settings.STORE_ENDPOINT_QUERY) || !configuration.containsKey(Settings.STORE_ENDPOINT_UPDATE)) {
                log.error("Incomplete configuration for sparql store");
                throw new IllegalStateException("Incomplete configuration");
            }
            String endpointQuery = configuration.getString(Settings.STORE_ENDPOINT_QUERY);
            String endpointUpdate = configuration.getString(Settings.STORE_ENDPOINT_UPDATE);
            String user = configuration.getString(Settings.STORE_USER);
            String password = configuration.getString(Settings.STORE_PWD);
            log.info("Using SPARQL repository at {}, {}", (Object)endpointQuery, (Object)endpointUpdate);
            this.repository = new SPARQLRepository(endpointQuery, endpointUpdate);
            if (user != null && password != null) {
                ((SPARQLRepository)this.repository).setUsernameAndPassword(user, password);
            }
        } else if (storeType.equalsIgnoreCase("lmdb")) {
            if (!configuration.containsKey(Settings.STORE_PATH)) {
                log.error("Incomplete configuration for LMDB store");
                throw new IllegalStateException("Incomplete configuration");
            }
            path = new File(configuration.getURI(Settings.STORE_PATH));
            indexes = configuration.getString(Settings.STORE_INDEXES);
            log.info("Main repository: using LMDB Store at {} with indexes {}", (Object)path, (Object)indexes);
            LmdbStore store = indexes != null ? new LmdbStore(path, new LmdbStoreConfig().setTripleIndexes(indexes)) : new LmdbStore(path);
            this.repository = new SailRepository((Sail)store);
        }
        if (this.repository == null) {
            log.error("Failed to create SailRepository");
            throw new IllegalStateException("Failed to create SailRepository");
        }
        this.softCache = new SoftCache();
        if (configuration.getString(Settings.REPOSITORY_CACHE, "off").equalsIgnoreCase("on")) {
            String cachePath = configuration.getString(Settings.REPOSITORY_CACHE_PATH);
            if (cachePath != null) {
                System.setProperty("ehcache.disk.store.dir", cachePath);
            } else {
                log.warn("No disk cache directory configured, creating temp directory");
                try {
                    File tmpFolder = FileOperations.createTempDirectory("ehcache", null);
                    tmpFolder.deleteOnExit();
                    System.setProperty("ehcache.disk.store.dir", tmpFolder.getAbsolutePath());
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
            this.cacheManager = new CacheManager();
            log.info("Disk cache activated, using {}", (Object)this.cacheManager.getDiskStorePath());
        } else {
            log.info("Disk cache not activated");
        }
        this.quotaEnabled = configuration.getString(Settings.DATA_QUOTA, "off").equalsIgnoreCase("on");
        if (this.quotaEnabled) {
            log.info("Context quotas enabled");
            String quotaValue = configuration.getString(Settings.DATA_QUOTA_DEFAULT);
            if (quotaValue == null) {
                log.info("Quota default set to UNLIMITED");
            } else {
                this.defaultQuota = StringUtils.convertUnitStringToByteSize(quotaValue);
                log.info("Quota default set to {} bytes", (Object)this.defaultQuota);
            }
        } else {
            log.info("Context quotas disabled");
        }
        String maxFileSizeValue = configuration.getString(Settings.DATA_MAX_FILE_SIZE);
        if (maxFileSizeValue == null) {
            log.info("Maximum file size set to UNLIMITED");
        } else {
            this.maximumFileSize = StringUtils.convertUnitStringToByteSize(maxFileSizeValue);
            log.info("Maximum file size set to {} bytes", (Object)maxFileSizeValue);
        }
        this.setCheckForAuthorization(false);
        try {
            try {
                this.baseURL = new URI(baseURL).toURL();
                NS.getMap().put("store", baseURL);
            }
            catch (MalformedURLException | URISyntaxException e1) {
                log.error(e1.getMessage());
            }
            this.systemContextAliasList.add("_contexts");
            this.systemContextAliasList.add("_principals");
            this.alias2Class.put("_contexts", ContextManagerImpl.class);
            this.alias2Class.put("_principals", PrincipalManagerImpl.class);
            try {
                this.repository.init();
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
            if ("on".equalsIgnoreCase(configuration.getString(Settings.REPOSITORY_PROVENANCE, "off"))) {
                this.initializeProvenanceRepository();
            }
            this.initialize();
            String baseURI = configuration.getString(Settings.BASE_URL);
            if (instances.containsKey(baseURI) || instances.containsValue(this)) {
                log.warn("This RepositoryManager instance has already been created, something is wrong");
            } else {
                log.info("Adding RepositoryManager instance to map: {},{}", (Object)baseURI, (Object)this);
                instances.put(baseURI, this);
            }
        }
        finally {
            this.setCheckForAuthorization(true);
        }
        trackDeletedEntries = configuration.getBoolean(Settings.REPOSITORY_TRACK_DELETED, false);
        log.info("Tracking of deleted entries is {}", (Object)(trackDeletedEntries ? "activated" : "deactivated"));
        boolean cleanupDeleted = configuration.getBoolean(Settings.REPOSITORY_TRACK_DELETED_CLEANUP, false);
        if (cleanupDeleted) {
            DataCorrection.cleanupTrackedDeletedEntries(this.repository);
        }
        if ("on".equalsIgnoreCase(configuration.getString(Settings.SOLR, "off")) && configuration.containsKey(Settings.SOLR_URL)) {
            log.info("Initializing Solr");
            this.initSolr();
            this.registerSolrListeners();
        }
        if ("on".equalsIgnoreCase(configuration.getString(Settings.REPOSITORY_PUBLIC, "off"))) {
            log.info("Initializing public repository");
            this.publicRepository = new PublicRepository(this);
            this.registerPublicRepositoryListeners();
        }
        log.info("Adding shutdown hook");
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    private void initializeProvenanceRepository() {
        String storeType = this.configuration.getString(Settings.REPOSITORY_PROVENANCE_TYPE, "memory").trim();
        log.info("Provenance repository type: " + storeType);
        if (storeType.equalsIgnoreCase("memory")) {
            this.provenanceRepository = new SailRepository((Sail)new MemoryStore());
        } else if (storeType.equalsIgnoreCase("native")) {
            if (!this.configuration.containsKey(Settings.REPOSITORY_PROVENANCE_PATH)) {
                log.error("Incomplete configuration of provenance repository");
            } else {
                File path = new File(this.configuration.getURI(Settings.REPOSITORY_PROVENANCE_PATH));
                String indexes = this.configuration.getString(Settings.REPOSITORY_PROVENANCE_INDEXES);
                this.checkAndUpgradeNativeStore(path, indexes);
                log.info("Provenance repository: using Native Store at {} with indexes {}", (Object)path, (Object)indexes);
                NativeStore store = indexes != null ? new NativeStore(path, indexes) : new NativeStore(path);
                this.provenanceRepository = new SailRepository((Sail)store);
            }
        }
        try {
            this.provenanceRepository.init();
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
        }
    }

    private void initialize() {
        this.contextManager = new ContextManagerImpl(this, this.repository);
        this.contextManager.initializeSystemEntries();
    }

    public static RepositoryManagerImpl getInstance(String baseURI) {
        RepositoryManagerImpl rm = instances.get(baseURI);
        if (rm != null) {
            log.info("Instance found for {}", (Object)baseURI);
        } else {
            log.info("No instance found for {}", (Object)baseURI);
        }
        return rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToFile(Repository repo, URI file, boolean gzip, RDFFormat format) {
        TriGWriterFactory rdfWriterFactory;
        RepositoryConnection con = null;
        OutputStream out = null;
        Date before = new Date();
        if (RDFFormat.TRIG.equals((Object)format)) {
            rdfWriterFactory = new TriGWriterFactory();
        } else if (RDFFormat.TRIX.equals((Object)format)) {
            rdfWriterFactory = new TriXWriterFactory();
        } else if (RDFFormat.NQUADS.equals((Object)format)) {
            rdfWriterFactory = new NQuadsWriterFactory();
        } else if (RDFFormat.BINARY.equals((Object)format)) {
            rdfWriterFactory = new BinaryRDFWriterFactory();
        } else {
            log.error("RDF format is not supported for backups: {}", (Object)format);
            return;
        }
        log.info("Exporting repository to {}", (Object)file);
        try {
            con = repo.getConnection();
            out = Files.newOutputStream(new File(file).toPath(), new OpenOption[0]);
            if (gzip) {
                out = new GZIPOutputStream(out);
            }
            out = new BufferedOutputStream(out);
            RDFWriter writer = rdfWriterFactory.getWriter(out);
            con.export((RDFHandler)writer, new Resource[0]);
        }
        catch (IOException | RepositoryException | RDFHandlerException e) {
            log.error(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    log.error(ioe.getMessage());
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (RepositoryException re) {
                    log.error(re.getMessage());
                }
            }
        }
        long timeDiff = new Date().getTime() - before.getTime();
        log.info("Export finished after {} ms", (Object)timeDiff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.shutdown) {
                try {
                    log.info("Shutting down Quartz scheduler");
                    StdSchedulerFactory.getDefaultScheduler().shutdown();
                }
                catch (SchedulerException se) {
                    log.error("Cannot shutdown Quartz scheduler: {}", (Object)se.getMessage());
                }
                log.info("Shutting down repository listeners and executor");
                this.repositoryListeners.clear();
                if (this.softCache != null) {
                    this.softCache.shutdown();
                }
                if (this.cacheManager != null) {
                    log.info("Shutting down EHCache manager");
                    this.cacheManager.shutdown();
                }
                if (this.solrIndex != null) {
                    log.info("Shutting down Solr support");
                    this.solrIndex.shutdown();
                }
                if (this.repository != null) {
                    log.info("Shutting down RDF4J repository");
                    try {
                        this.repository.shutDown();
                    }
                    catch (RepositoryException re) {
                        log.error("Error when shutting down RDF4J repository: {}", (Object)re.getMessage());
                        re.printStackTrace();
                    }
                }
                if (this.publicRepository != null) {
                    log.info("Shutting down public repository");
                    this.publicRepository.shutdown();
                }
                if (this.provenanceRepository != null) {
                    log.info("Shutting down RDF4J provenance repository");
                    try {
                        this.provenanceRepository.shutDown();
                    }
                    catch (RepositoryException re) {
                        log.error("Error when shutting down RDF4J provenance repository: {}", (Object)re.getMessage());
                    }
                }
                if (this.solrServer != null) {
                    try {
                        this.solrServer.close();
                    }
                    catch (IOException e) {
                        log.error("Error when shutting down Solr Server");
                    }
                }
                this.shutdown = true;
            }
        }
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public PrincipalManager getPrincipalManager() {
        if (this.principalManager == null && this.contextManager != null) {
            this.principalManager = (PrincipalManager)this.contextManager.getContext(this.systemContextAliasList.get(1));
        }
        return this.principalManager;
    }

    public URL getRepositoryURL() {
        return this.baseURL;
    }

    public List<String> getSystemContextAliases() {
        return this.systemContextAliasList;
    }

    public Class getSystemContextClassForAlias(String alias) {
        return this.alias2Class.get(alias);
    }

    public Class getRegularContextClass() {
        return RegularContext.class;
    }

    public boolean hasModificationLockOut() {
        return this.modificationLockout;
    }

    public void setModificationLockOut(boolean lockout) {
        log.info("Lock out set to {}", (Object)lockout);
        this.modificationLockout = lockout;
    }

    public boolean hasQuotas() {
        return this.quotaEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRepositoryEvent(RepositoryEventObject eventObject) {
        Map<RepositoryEvent, Set<RepositoryListener>> map = this.repositoryListeners;
        synchronized (map) {
            if (this.repositoryListeners.containsKey(eventObject.getEvent())) {
                for (RepositoryListener repositoryListener : this.repositoryListeners.get(eventObject.getEvent())) {
                    repositoryListener.repositoryUpdated(eventObject);
                }
            }
            if (this.repositoryListeners.containsKey(RepositoryEvent.All)) {
                for (RepositoryListener repositoryListener : this.repositoryListeners.get(RepositoryEvent.All)) {
                    repositoryListener.repositoryUpdated(eventObject);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(RepositoryListener listener, RepositoryEvent event) {
        Map<RepositoryEvent, Set<RepositoryListener>> map = this.repositoryListeners;
        synchronized (map) {
            Set<RepositoryListener> listeners = this.repositoryListeners.get(event);
            if (listeners == null) {
                listeners = new HashSet<RepositoryListener>();
            }
            listeners.add(listener);
            this.repositoryListeners.put(event, listeners);
            log.info("Registered new RepositoryListener: {}", (Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(RepositoryListener listener, RepositoryEvent event) {
        Map<RepositoryEvent, Set<RepositoryListener>> map = this.repositoryListeners;
        synchronized (map) {
            Set<RepositoryListener> listeners = this.repositoryListeners.get(event);
            if (listeners != null) {
                listeners.remove(listener);
                this.repositoryListeners.put(event, listeners);
                log.info("Unregistered RepositoryListener: {}", (Object)listener);
            }
        }
    }

    private void initSolr() {
        String solrURL;
        log.info("Manually setting property \"javax.xml.parsers.DocumentBuilderFactory\" to \"com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl\"");
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        boolean reindex = this.configuration.getBoolean(Settings.SOLR_REINDEX_ON_STARTUP, false);
        boolean reindexWait = this.configuration.getBoolean(Settings.SOLR_REINDEX_ON_STARTUP_WAIT, false);
        if (!reindex && "memory".equalsIgnoreCase(this.configuration.getString(Settings.STORE_TYPE)) && !this.configuration.containsKey(Settings.STORE_PATH)) {
            reindex = true;
        }
        if ((solrURL = this.configuration.getString(Settings.SOLR_URL)).startsWith("http://") || solrURL.startsWith("https://")) {
            log.info("Using HTTP Solr server at {}", (Object)solrURL);
            HttpSolrClient.Builder solrClientBuilder = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(solrURL).withConnectionTimeout(5000)).withSocketTimeout(5000)).allowCompression(true);
            String solrUsername = this.configuration.getString(Settings.SOLR_AUTH_USERNAME);
            String solrPassword = this.configuration.getString(Settings.SOLR_AUTH_PASSWORD);
            if (solrUsername != null && solrPassword != null) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(solrUsername, solrPassword);
                provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                CloseableHttpClient solrHttpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
                solrClientBuilder.withHttpClient((HttpClient)solrHttpClient);
            }
            HttpSolrClient httpSolrClient = solrClientBuilder.build();
            httpSolrClient.setFollowRedirects(true);
            this.solrServer = httpSolrClient;
        } else {
            File solrCoreConfDir;
            log.info("Using embedded Solr server");
            String coreName = "core1";
            String schemaFileName = "SCHEMA_VERSION";
            String solrFileName = "SOLR_VERSION";
            File solrDir = new File(solrURL);
            File solrSchemaVersionFile = new File(solrDir, schemaFileName);
            File solrVersionFile = new File(solrDir, solrFileName);
            if (solrSchemaVersionFile.isFile()) {
                String schemaVersion = null;
                try {
                    schemaVersion = IOUtils.toString((URI)solrSchemaVersionFile.toURI(), (Charset)StandardCharsets.UTF_8);
                    schemaVersion = schemaVersion.replace("\n", "");
                    schemaVersion = schemaVersion.replace("\r", "");
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                String solrVersion = null;
                try {
                    solrVersion = IOUtils.toString((URI)solrVersionFile.toURI(), (Charset)StandardCharsets.UTF_8);
                    solrVersion = solrVersion.replace("\n", "");
                    solrVersion = solrVersion.replace("\r", "");
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                boolean solrVersionMismatch = true;
                if (solrVersion != null) {
                    SolrVersion solrVersionOfIndex = SolrVersion.valueOf((String)solrVersion);
                    if (SolrVersion.LATEST.getMajorVersion() == solrVersionOfIndex.getMajorVersion() && SolrVersion.LATEST.getMinorVersion() == solrVersionOfIndex.getMinorVersion()) {
                        solrVersionMismatch = false;
                    }
                }
                if (!RepositoryManagerImpl.getVersion().equals(schemaVersion) || solrVersionMismatch) {
                    if (solrVersion == null) {
                        solrVersion = "<unknown>";
                    }
                    log.warn("Solr index was created with: EntryStore {} (running version is {}) and Solr {} (running version is {})", new Object[]{schemaVersion, RepositoryManagerImpl.getVersion(), solrVersion, SolrVersion.LATEST});
                    log.warn("Deleting contents of Solr directory at {} to trigger a clean reindex with current Solr schema", (Object)solrDir);
                    try {
                        FileUtils.cleanDirectory((File)solrDir);
                    }
                    catch (IOException e) {
                        log.error(e.getMessage());
                    }
                }
            }
            if (solrDir.list() != null && Objects.requireNonNull(solrDir.list()).length == 0) {
                log.info("Solr directory is empty, scheduling conditional reindexing of repository");
                reindex = true;
                reindexWait = true;
                try {
                    log.info("Writing EntryStore version to schema version file at {}", (Object)solrSchemaVersionFile);
                    FileOperations.writeStringToFile(solrSchemaVersionFile, RepositoryManagerImpl.getVersion());
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                try {
                    log.info("Writing Solr version to version file at {}", (Object)solrVersionFile);
                    FileOperations.writeStringToFile(solrVersionFile, SolrVersion.LATEST.toString());
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
            if (!(solrCoreConfDir = new File(new File(solrDir, coreName), "conf")).exists() && !solrCoreConfDir.mkdirs()) {
                log.warn("Unable to create directory {}", (Object)solrCoreConfDir);
            }
            URL solrConfigXmlSource = this.configuration.getURL(Settings.SOLR_CONFIG_URL, ConverterUtil.findResource("solrconfig.xml_default"));
            File solrConfigXmlDest = new File(solrCoreConfDir, "solrconfig.xml");
            try {
                log.info("Copying Solr solrconfig.xml from {} to {}", (Object)solrConfigXmlSource, (Object)solrConfigXmlDest);
                Files.copy(solrConfigXmlSource.openStream(), solrConfigXmlDest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            URL solrSchemaXmlSource = this.configuration.getURL(Settings.SOLR_SCHEMA_URL, ConverterUtil.findResource("schema.xml_default"));
            File solrSchemaXmlDest = new File(solrCoreConfDir, "schema.xml");
            try {
                log.info("Copying Solr schema.xml from {} to {}", (Object)solrSchemaXmlSource, (Object)solrSchemaXmlDest);
                Files.copy(solrSchemaXmlSource.openStream(), solrSchemaXmlDest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            try {
                System.setProperty("solr.install.dir", solrDir.getCanonicalPath());
                NodeConfig config = new NodeConfig.NodeConfigBuilder("embeddedSolrServerNode", solrDir.toPath()).setConfigSetBaseDirectory(solrURL).build();
                this.solrServer = new EmbeddedSolrServer(config, coreName);
                try {
                    CoreStatus status = CoreAdminRequest.getCoreStatus((String)coreName, (SolrClient)this.solrServer);
                    status.getCoreStartTime();
                }
                catch (Exception e) {
                    log.info("Creating Solr core");
                    CoreAdminRequest.Create createRequest = new CoreAdminRequest.Create();
                    createRequest.setCoreName(coreName);
                    createRequest.setConfigSet("");
                    createRequest.process(this.solrServer);
                    reindex = true;
                    reindexWait = true;
                }
            }
            catch (Exception e) {
                log.error("Failed to initialize Solr: {}", (Object)e.getMessage());
            }
        }
        if (this.solrServer != null) {
            this.solrIndex = new SolrSearchIndex(this, this.solrServer);
            if (reindex) {
                if (reindexWait) {
                    this.solrIndex.clearSolrIndex(this.solrServer);
                    this.solrIndex.reindexSync(false);
                } else {
                    this.solrIndex.reindex(false);
                }
            }
        } else {
            log.error("Unable to initialize Solr");
            this.shutdown();
        }
    }

    private void registerSolrListeners() {
        if (this.solrServer != null) {
            RepositoryListener updater = new RepositoryListener(){

                public void repositoryUpdated(RepositoryEventObject eventObject) {
                    if (eventObject.getSource() != null && eventObject.getSource() instanceof Entry) {
                        RepositoryManagerImpl.this.solrIndex.postEntry((Entry)eventObject.getSource());
                    }
                }
            };
            this.registerListener(updater, RepositoryEvent.EntryCreated);
            this.registerListener(updater, RepositoryEvent.EntryUpdated);
            this.registerListener(updater, RepositoryEvent.MetadataUpdated);
            this.registerListener(updater, RepositoryEvent.ExternalMetadataUpdated);
            this.registerListener(updater, RepositoryEvent.ResourceUpdated);
            this.registerListener(updater, RepositoryEvent.RelationsUpdated);
            RepositoryListener remover = new RepositoryListener(){

                public void repositoryUpdated(RepositoryEventObject eventObject) {
                    if (eventObject.getSource() != null && eventObject.getSource() instanceof Entry) {
                        RepositoryManagerImpl.this.solrIndex.removeEntry((Entry)eventObject.getSource());
                    }
                }
            };
            this.registerListener(remover, RepositoryEvent.EntryDeleted);
            RepositoryListener contextIndexer = new RepositoryListener(){

                public void repositoryUpdated(RepositoryEventObject eventObject) {
                    Entry e;
                    Object object;
                    if (eventObject.getSource() != null && (object = eventObject.getSource()) instanceof Entry && GraphType.Context.equals((Object)(e = (Entry)object).getGraphType())) {
                        RepositoryManagerImpl.this.solrIndex.submitContextForDelayedReindex(e, eventObject.getUpdatedGraph());
                    }
                }
            };
            this.registerListener(contextIndexer, RepositoryEvent.EntryAclGuestUpdated);
            this.registerListener(contextIndexer, RepositoryEvent.EntryProjectTypeUpdated);
        }
    }

    public SearchIndex getIndex() {
        return this.solrIndex;
    }

    private void registerPublicRepositoryListeners() {
        if (this.publicRepository != null) {
            RepositoryListener updater = new RepositoryListener(){

                public void repositoryUpdated(RepositoryEventObject eventObject) {
                    if (eventObject.getSource() != null && eventObject.getSource() instanceof Entry) {
                        RepositoryManagerImpl.this.publicRepository.enqueue((Entry)eventObject.getSource());
                    }
                }
            };
            this.registerListener(updater, RepositoryEvent.EntryCreated);
            this.registerListener(updater, RepositoryEvent.EntryUpdated);
            this.registerListener(updater, RepositoryEvent.MetadataUpdated);
            this.registerListener(updater, RepositoryEvent.ExternalMetadataUpdated);
            this.registerListener(updater, RepositoryEvent.ResourceUpdated);
            this.registerListener(updater, RepositoryEvent.RelationsUpdated);
            RepositoryListener remover = new RepositoryListener(){

                public void repositoryUpdated(RepositoryEventObject eventObject) {
                    if (eventObject.getSource() != null && eventObject.getSource() instanceof Entry) {
                        RepositoryManagerImpl.this.publicRepository.remove((Entry)eventObject.getSource());
                    }
                }
            };
            this.registerListener(remover, RepositoryEvent.EntryDeleted);
        }
    }

    public ValueFactory getValueFactory() {
        if (this.repository != null) {
            return this.repository.getValueFactory();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndUpgradeNativeStore(File path, String indexes) {
        long newContextCount;
        long oldContextCount;
        long newTripleCount;
        long oldTripleCount;
        if (path.exists() && path.isDirectory() && (Objects.requireNonNull(path.list()).length == 0 || new File(path, "nativerdf.ver").exists())) {
            return;
        }
        long before = new Date().getTime();
        log.warn("Unable to detect version of Native Store at {}, attempting upgrade", (Object)path);
        File valuesDat = new File(path, "values.dat");
        if (!valuesDat.exists()) {
            throw new RuntimeException(String.valueOf(valuesDat) + " not found, is the path of the Native Store (" + String.valueOf(path) + ") configured properly?");
        }
        File backupPath = new File(path, "backup");
        if (backupPath.exists() && backupPath.isDirectory() && Objects.requireNonNull(backupPath.list()).length > 0) {
            throw new RuntimeException("Backup path at " + String.valueOf(backupPath) + " exists and is not empty");
        }
        if (!backupPath.exists() && !backupPath.mkdirs()) {
            throw new RuntimeException("Backup path at " + String.valueOf(backupPath) + " could not be created");
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path.toPath());){
            for (Path p : stream) {
                if ("backup".equals(p.getFileName().toString())) continue;
                log.debug("Moving {} to {}", (Object)p, (Object)new File(backupPath, p.getFileName().toString()).toPath());
                Files.move(p, new File(backupPath, p.getFileName().toString()).toPath(), new CopyOption[0]);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        SailRepository oldRepo = new SailRepository((Sail)new NativeStore(backupPath, indexes));
        oldRepo.init();
        SailRepository newRepo = new SailRepository((Sail)new NativeStore(path, indexes));
        newRepo.init();
        try (SailRepositoryConnection rcOld = oldRepo.getConnection();){
            try (SailRepositoryConnection rcNew = newRepo.getConnection();){
                rcNew.add(rcOld.getStatements(null, null, null, false, new Resource[0]), new Resource[0]);
                oldTripleCount = rcOld.size(new Resource[0]);
                newTripleCount = rcNew.size(new Resource[0]);
                oldContextCount = rcOld.getContextIDs().stream().count();
                newContextCount = rcNew.getContextIDs().stream().count();
            }
            finally {
                newRepo.shutDown();
            }
        }
        finally {
            oldRepo.shutDown();
        }
        if (oldTripleCount != newTripleCount || oldContextCount != newContextCount) {
            throw new RuntimeException("Amount of triples or contexts in migrated Native Store at " + String.valueOf(path) + " is not the same as in original Native Store");
        }
        log.info("Repository statistics for {}: {} triples, {} named graphs", new Object[]{path, newTripleCount, newContextCount});
        try {
            FileUtils.deleteDirectory((File)backupPath);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        log.info("Native store at {} successfully upgraded, took {} ms", (Object)path, (Object)(new Date().getTime() - before));
    }

    public long getNamedGraphCount() {
        try (RepositoryConnection rc = this.repository.getConnection();){
            long l = rc.getContextIDs().stream().count();
            return l;
        }
    }

    public long getTripleCount() {
        try (RepositoryConnection rc = this.repository.getConnection();){
            long l = rc.size(new Resource[0]);
            return l;
        }
    }

    public static String getVersion() {
        if (VERSION == null) {
            URI versionFile = ConfigurationManager.getConfigurationURI("VERSION.txt");
            if (versionFile != null) {
                try {
                    log.debug("Reading version number from {}", (Object)versionFile);
                    VERSION = IOUtils.toString((URI)versionFile, (Charset)StandardCharsets.UTF_8);
                    VERSION = VERSION.replace("\n", "");
                    VERSION = VERSION.replace("\r", "");
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
            if (VERSION == null) {
                VERSION = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
            }
        }
        return VERSION;
    }

    @Generated
    public Repository getRepository() {
        return this.repository;
    }

    @Generated
    public void setCheckForAuthorization(boolean checkForAuthorization) {
        this.checkForAuthorization = checkForAuthorization;
    }

    @Generated
    public boolean isCheckForAuthorization() {
        return this.checkForAuthorization;
    }

    @Generated
    public SoftCache getSoftCache() {
        return this.softCache;
    }

    @Generated
    public Config getConfiguration() {
        return this.configuration;
    }

    @Generated
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Generated
    public long getDefaultQuota() {
        return this.defaultQuota;
    }

    @Generated
    public long getMaximumFileSize() {
        return this.maximumFileSize;
    }

    @Generated
    public PublicRepository getPublicRepository() {
        return this.publicRepository;
    }

    @Generated
    public Repository getProvenanceRepository() {
        return this.provenanceRepository;
    }

    static {
        VERSION = null;
    }
}

