/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.entrystore.Context;
import org.entrystore.Entry;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.impl.EntryImpl;
import org.entrystore.impl.RDFResource;
import org.entrystore.impl.RepositoryProperties;
import org.entrystore.impl.SoftCache;
import org.entrystore.repository.RepositoryEvent;
import org.entrystore.repository.RepositoryEventObject;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.security.Password;
import org.entrystore.repository.test.TestSuite;
import org.entrystore.repository.util.NS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserImpl
extends RDFResource
implements User {
    static Logger log = LoggerFactory.getLogger(UserImpl.class);
    private String saltedHashedSecret;
    private String language;
    private URI homeContext;
    private String externalID;
    private RepositoryManager rm;
    public static final IRI customProperty;
    public static final IRI customPropertyKey;
    public static final IRI customPropertyValue;

    protected UserImpl(EntryImpl entry, IRI resourceURI, SoftCache cache) {
        super(entry, resourceURI);
        this.rm = entry.getRepositoryManager();
    }

    public String getName() {
        return ((PrincipalManager)this.entry.getContext()).getPrincipalName(this.getURI());
    }

    public boolean setName(String newName) {
        return ((PrincipalManager)this.entry.getContext()).setPrincipalName(this.getURI(), newName);
    }

    @Deprecated
    public String getSecret() {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadResource);
        String secret = null;
        RepositoryConnection rc = null;
        try {
            rc = this.entry.repository.getConnection();
            List matches = rc.getStatements((Resource)this.resourceURI, RepositoryProperties.secret, null, false, new Resource[]{this.resourceURI}).asList();
            if (!matches.isEmpty()) {
                secret = ((Statement)matches.get(0)).getObject().stringValue();
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e));
        }
        finally {
            try {
                rc.close();
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return secret;
    }

    public String getSaltedHashedSecret() {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadResource);
        if (this.saltedHashedSecret == null) {
            if (this.rm.getPrincipalManager().getAdminUser().getEntry().getId().equals(this.entry.getId()) && this.rm.getConfiguration().containsKey(Settings.AUTH_ADMIN_SECRET)) {
                log.warn("Admin secret override in config file");
                try {
                    this.saltedHashedSecret = Password.getSaltedHash(this.rm.getConfiguration().getString(Settings.AUTH_ADMIN_SECRET));
                    return this.saltedHashedSecret;
                }
                catch (IllegalArgumentException iae) {
                    log.error("Admin secret override was not successful due to password rule violation");
                }
            }
            RepositoryConnection rc = null;
            try {
                rc = this.entry.repository.getConnection();
                List matches = rc.getStatements((Resource)this.resourceURI, RepositoryProperties.saltedHashedSecret, null, false, new Resource[]{this.resourceURI}).asList();
                if (!matches.isEmpty()) {
                    this.saltedHashedSecret = ((Statement)matches.get(0)).getObject().stringValue();
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e));
            }
            finally {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.saltedHashedSecret;
    }

    public boolean setSecret(String secret) {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        if (!this.entry.getRepositoryManager().getPrincipalManager().isValidSecret(secret)) {
            return false;
        }
        String shSecret = null;
        try {
            shSecret = Password.getSaltedHash(secret);
        }
        catch (IllegalArgumentException iae) {
            log.info(iae.getMessage());
            return false;
        }
        return this.setSaltedHashedSecret(shSecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSaltedHashedSecret(String shSecret) {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        Repository repository = this.entry.repository;
        synchronized (repository) {
            boolean bl;
            RepositoryConnection rc = this.entry.repository.getConnection();
            ValueFactory vf = this.entry.repository.getValueFactory();
            rc.begin();
            try {
                rc.remove(rc.getStatements((Resource)this.resourceURI, RepositoryProperties.secret, null, false, new Resource[]{this.resourceURI}), new Resource[]{this.resourceURI});
                rc.remove(rc.getStatements((Resource)this.resourceURI, RepositoryProperties.saltedHashedSecret, null, false, new Resource[]{this.resourceURI}), new Resource[]{this.resourceURI});
                rc.add((Resource)this.resourceURI, RepositoryProperties.saltedHashedSecret, (Value)vf.createLiteral(shSecret), new Resource[]{this.resourceURI});
                this.entry.updateModifiedDateSynchronized(rc, vf);
                rc.commit();
                this.saltedHashedSecret = shSecret;
                this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
                bl = true;
            }
            catch (Exception e) {
                try {
                    try {
                        log.error(e.getMessage(), (Throwable)e);
                        rc.rollback();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        rc.close();
                    }
                }
                catch (RepositoryException e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                    throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e2));
                }
            }
            rc.close();
            return bl;
        }
        return false;
    }

    public void setMetadata(Entry entry, String title, String desc) {
        try {
            Model graph = entry.getLocalMetadata().getGraph();
            SimpleValueFactory vf = SimpleValueFactory.getInstance();
            IRI root = vf.createIRI(entry.getResourceURI().toString());
            graph.add((Resource)root, TestSuite.dc_title, (Value)vf.createLiteral(title, "en"), new Resource[0]);
            if (desc != null) {
                graph.add((Resource)root, TestSuite.dc_description, (Value)vf.createLiteral(desc, "en"), new Resource[0]);
            }
            entry.getLocalMetadata().setGraph(graph);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public Context getHomeContext() {
        Entry eContext;
        if (this.homeContext == null) {
            RepositoryConnection rc = null;
            try {
                rc = this.entry.repository.getConnection();
                List matches = rc.getStatements((Resource)this.resourceURI, RepositoryProperties.homeContext, null, false, new Resource[]{this.entry.getSesameEntryURI()}).asList();
                if (!matches.isEmpty()) {
                    this.homeContext = URI.create(((Statement)matches.get(0)).getObject().stringValue());
                } else {
                    matches = rc.getStatements((Resource)this.resourceURI, RepositoryProperties.homeContext, null, false, new Resource[]{this.resourceURI}).asList();
                    if (!matches.isEmpty()) {
                        this.homeContext = URI.create(((Statement)matches.get(0)).getObject().stringValue());
                    }
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
            }
            finally {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.homeContext != null && (eContext = this.entry.getRepositoryManager().getContextManager().getByEntryURI(this.homeContext)) != null) {
            return (Context)eContext.getResource();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setHomeContext(Context context) {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        Repository repository = this.entry.repository;
        synchronized (repository) {
            boolean bl;
            RepositoryConnection rc = this.entry.repository.getConnection();
            ValueFactory vf = this.entry.repository.getValueFactory();
            rc.begin();
            try {
                RepositoryResult iter = rc.getStatements((Resource)this.resourceURI, RepositoryProperties.homeContext, null, false, new Resource[]{this.entry.getSesameEntryURI()});
                while (iter.hasNext()) {
                    Statement statement = (Statement)iter.next();
                    URI sourceEntryURI = URI.create(statement.getObject().stringValue());
                    EntryImpl sourceEntry = (EntryImpl)this.entry.getRepositoryManager().getContextManager().getEntry(sourceEntryURI);
                    if (sourceEntry != null) {
                        sourceEntry.removeRelationSynchronized(statement, rc);
                    }
                    rc.remove(statement, new Resource[]{this.entry.getSesameEntryURI()});
                }
                iter.close();
                rc.remove(rc.getStatements((Resource)this.resourceURI, RepositoryProperties.homeContext, null, false, new Resource[]{this.resourceURI}), new Resource[]{this.resourceURI});
                if (context != null) {
                    Statement newStatement = vf.createStatement((Resource)this.resourceURI, RepositoryProperties.homeContext, (Value)((EntryImpl)context.getEntry()).getSesameEntryURI(), (Resource)this.entry.getSesameEntryURI());
                    rc.add(newStatement, new Resource[0]);
                    ((EntryImpl)context.getEntry()).addRelationSynchronized(newStatement, rc);
                }
                this.entry.updateModifiedDateSynchronized(rc, vf);
                rc.commit();
                this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
                bl = true;
            }
            catch (Exception e) {
                try {
                    try {
                        log.error(e.getMessage(), (Throwable)e);
                        rc.rollback();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        rc.close();
                        this.entry.invRelations = true;
                        this.homeContext = context.getEntry().getEntryURI();
                    }
                }
                catch (RepositoryException e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                    throw new org.entrystore.repository.RepositoryException("Failed to connect to repository.", (Exception)((Object)e2));
                }
            }
            rc.close();
            this.entry.invRelations = true;
            this.homeContext = context.getEntry().getEntryURI();
            return bl;
        }
        return false;
    }

    public String getLanguage() {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadResource);
        if (this.language == null) {
            RepositoryConnection rc = null;
            try {
                rc = this.entry.repository.getConnection();
                List matches = rc.getStatements((Resource)this.resourceURI, RepositoryProperties.language, null, false, new Resource[]{this.resourceURI}).asList();
                if (!matches.isEmpty()) {
                    this.language = ((Statement)matches.get(0)).getObject().stringValue();
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
            }
            finally {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setLanguage(String language) {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        Repository repository = this.entry.repository;
        synchronized (repository) {
            boolean bl;
            RepositoryConnection rc = this.entry.repository.getConnection();
            ValueFactory vf = this.entry.repository.getValueFactory();
            rc.begin();
            try {
                rc.remove(rc.getStatements((Resource)this.resourceURI, RepositoryProperties.language, null, false, new Resource[]{this.resourceURI}), new Resource[]{this.resourceURI});
                if (language != null) {
                    rc.add((Resource)this.resourceURI, RepositoryProperties.language, (Value)vf.createLiteral(language), new Resource[]{this.resourceURI});
                }
                this.entry.updateModifiedDateSynchronized(rc, vf);
                rc.commit();
                this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
                bl = true;
            }
            catch (Exception e) {
                try {
                    try {
                        log.error(e.getMessage(), (Throwable)e);
                        rc.rollback();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        rc.close();
                        this.language = language;
                    }
                }
                catch (RepositoryException e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                    throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e2));
                }
            }
            rc.close();
            this.language = language;
            return bl;
        }
        return false;
    }

    public String getExternalID() {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadResource);
        if (this.externalID == null) {
            RepositoryConnection rc = null;
            try {
                rc = this.entry.repository.getConnection();
                List matches = rc.getStatements((Resource)this.resourceURI, RepositoryProperties.externalID, null, false, new Resource[]{this.resourceURI}).asList();
                if (!matches.isEmpty()) {
                    this.externalID = ((Statement)matches.get(0)).getObject().stringValue();
                    String prefix = "mailto:";
                    if (this.externalID.contains(prefix)) {
                        this.externalID = this.externalID.substring(this.externalID.lastIndexOf(prefix) + prefix.length());
                    }
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e));
            }
            finally {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.externalID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setExternalID(String eid) {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        Repository repository = this.entry.repository;
        synchronized (repository) {
            boolean bl;
            RepositoryConnection rc = this.entry.repository.getConnection();
            ValueFactory vf = this.entry.repository.getValueFactory();
            rc.begin();
            try {
                rc.remove(rc.getStatements((Resource)this.resourceURI, RepositoryProperties.externalID, null, false, new Resource[]{this.resourceURI}), new Resource[]{this.resourceURI});
                if (eid != null) {
                    rc.add((Resource)this.resourceURI, RepositoryProperties.externalID, (Value)vf.createIRI("mailto:", eid), new Resource[]{this.resourceURI});
                    this.entry.updateModifiedDateSynchronized(rc, vf);
                }
                rc.commit();
                this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
                bl = true;
            }
            catch (Exception e) {
                try {
                    try {
                        log.error(e.getMessage(), (Throwable)e);
                        rc.rollback();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        rc.close();
                        this.externalID = eid;
                    }
                }
                catch (RepositoryException e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                    throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e2));
                }
            }
            rc.close();
            this.externalID = eid;
            return bl;
        }
        return false;
    }

    public Set<URI> getGroups() {
        HashSet<URI> set = new HashSet<URI>();
        Model relations = this.entry.getRelations();
        if (relations != null) {
            for (Statement statement : relations) {
                if (!statement.getPredicate().equals((Object)RepositoryProperties.hasGroupMember)) continue;
                set.add(URI.create(statement.getSubject().toString()));
            }
        }
        return set;
    }

    public Map<String, String> getCustomProperties() {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadResource);
        HashMap<String, String> result = new HashMap<String, String>();
        Model userResourceGraph = this.getGraph();
        for (Statement s : userResourceGraph.filter((Resource)this.resourceURI, customProperty, null, new Resource[0])) {
            Value argKey;
            if (!(s.getObject() instanceof BNode)) continue;
            String keyStr = null;
            String valueStr = null;
            Iterator argKeyIt = userResourceGraph.filter((Resource)((BNode)s.getObject()), customPropertyKey, null, new Resource[0]).iterator();
            if (argKeyIt.hasNext() && (argKey = ((Statement)argKeyIt.next()).getObject()) instanceof Literal) {
                Value argValue;
                keyStr = ((Literal)argKey).stringValue();
                Iterator argValueIt = userResourceGraph.filter((Resource)((BNode)s.getObject()), customPropertyValue, null, new Resource[0]).iterator();
                if (argValueIt.hasNext() && (argValue = ((Statement)argValueIt.next()).getObject()) instanceof Literal) {
                    valueStr = ((Literal)argValue).stringValue();
                }
            }
            if (keyStr == null || valueStr == null) continue;
            result.put(keyStr.toLowerCase(), valueStr);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCustomProperties(Map<String, String> properties) {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        if (properties == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
        Repository repository = this.entry.repository;
        synchronized (repository) {
            boolean bl;
            RepositoryConnection rc = this.entry.repository.getConnection();
            ValueFactory vf = this.entry.repository.getValueFactory();
            rc.begin();
            try {
                rc.remove(rc.getStatements(null, customProperty, null, false, new Resource[]{this.resourceURI}), new Resource[]{this.resourceURI});
                rc.remove(rc.getStatements(null, customPropertyKey, null, false, new Resource[]{this.resourceURI}), new Resource[]{this.resourceURI});
                rc.remove(rc.getStatements(null, customPropertyValue, null, false, new Resource[]{this.resourceURI}), new Resource[]{this.resourceURI});
                for (Map.Entry<String, String> e : properties.entrySet()) {
                    BNode bnode = vf.createBNode();
                    rc.add((Resource)this.resourceURI, customProperty, (Value)bnode, new Resource[]{this.resourceURI});
                    rc.add((Resource)bnode, customPropertyKey, (Value)vf.createLiteral(e.getKey()), new Resource[]{this.resourceURI});
                    rc.add((Resource)bnode, customPropertyValue, (Value)vf.createLiteral(e.getValue()), new Resource[]{this.resourceURI});
                }
                this.entry.updateModifiedDateSynchronized(rc, vf);
                rc.commit();
                this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
                bl = true;
            }
            catch (Exception e) {
                try {
                    try {
                        log.error(e.getMessage(), (Throwable)e);
                        rc.rollback();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        rc.close();
                    }
                }
                catch (RepositoryException e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                    throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e2));
                }
            }
            rc.close();
            return bl;
        }
        return false;
    }

    public boolean isDisabled() {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadResource);
        RepositoryConnection rc = null;
        try {
            rc = this.entry.repository.getConnection();
            List matches = rc.getStatements((Resource)this.resourceURI, RepositoryProperties.disabled, null, false, new Resource[]{this.resourceURI}).asList();
            if (!matches.isEmpty()) {
                Literal l = (Literal)((Statement)matches.get(0)).getObject();
                boolean bl = l.booleanValue();
                return bl;
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e));
        }
        finally {
            try {
                if (rc != null) {
                    rc.close();
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisabled(boolean disabled) {
        this.rm.getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        try {
            Repository repository = this.entry.repository;
            synchronized (repository) {
                ValueFactory vf = this.entry.repository.getValueFactory();
                try (RepositoryConnection rc = this.entry.repository.getConnection();){
                    rc.begin();
                    rc.remove(rc.getStatements((Resource)this.resourceURI, RepositoryProperties.disabled, null, false, new Resource[]{this.resourceURI}), new Resource[]{this.resourceURI});
                    if (disabled) {
                        rc.add((Resource)this.resourceURI, RepositoryProperties.disabled, (Value)vf.createLiteral(disabled), new Resource[]{this.resourceURI});
                    }
                    this.entry.updateModifiedDateSynchronized(rc, vf);
                    rc.commit();
                    this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
                }
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e));
        }
    }

    static {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        customProperty = vf.createIRI(NS.entrystore, "customProperty");
        customPropertyKey = vf.createIRI(NS.entrystore, "customPropertyKey");
        customPropertyValue = vf.createIRI(NS.entrystore, "customPropertyValue");
    }
}

