/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.net.URI;
import java.util.StringTokenizer;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.entrystore.impl.EntryImpl;
import org.entrystore.repository.RepositoryManager;

public class Util {
    public static StringTokenizer extractParameters(RepositoryManager rman, IRI uri) {
        return Util.extractParameters(rman, uri.toString());
    }

    public static StringTokenizer extractParameters(RepositoryManager rman, String uri) {
        String withoutBase = uri.substring(rman.getRepositoryURL().toString().length());
        return new StringTokenizer(withoutBase, "/");
    }

    public static IRI getMetadataURI(EntryImpl item, String contextID, String uniqueID) {
        ValueFactory vf = item.getRepository().getValueFactory();
        String base = item.getRepositoryManager().getRepositoryURL().toString();
        return vf.createIRI(base + contextID + "/metadata/" + uniqueID);
    }

    public static URI getMMdURIFromMdURI(IRI md) {
        return URI.create(md.toString().replaceFirst("/metadata/", "/entry/"));
    }

    public static String getContextIdFromURI(RepositoryManager rman, URI sourceURI) {
        return Util.extractParameters(rman, sourceURI.toString()).nextToken();
    }

    public static URI getContextURIFromURI(RepositoryManager rman, URI sourceURI) {
        return URI.create(rman.getRepositoryURL().toString() + "/_contexts/resource/" + Util.getContextIdFromURI(rman, sourceURI));
    }

    public static URI getContextMMdURIFromURI(RepositoryManager rman, URI sourceURI) {
        return URI.create(rman.getRepositoryURL().toString() + "/_contexts/entry/" + Util.getContextIdFromURI(rman, sourceURI));
    }
}

