/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import lombok.Generated;
import org.entrystore.config.Config;
import org.entrystore.config.Configurations;
import org.entrystore.repository.config.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    static Logger log = LoggerFactory.getLogger(ConfigurationManager.class);
    private Config configuration;
    public static String CONFIG_FILE = "entrystore.properties";

    public ConfigurationManager(URI configURI) throws IOException {
        if (configURI == null) {
            throw new IllegalArgumentException("Configuration URI must not be null");
        }
        try {
            log.info("Loading configuration from: {}", (Object)configURI);
            this.loadConfiguration(configURI.toURL());
        }
        catch (MalformedURLException e) {
            log.error(e.getMessage());
        }
    }

    private void initMainConfig() {
        this.configuration = Configurations.synchronizedConfig((Config)new PropertiesConfiguration("EntryStore Configuration"));
    }

    private void loadConfiguration(URL configURL) throws IOException {
        this.initMainConfig();
        this.configuration.load(configURL);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException(String.valueOf(this.getClass()) + " is a Singleton.");
    }

    public static URI getConfigurationURI(String fileName) {
        String[] pathElements;
        URL resURL = Thread.currentThread().getContextClassLoader().getResource(fileName);
        try {
            if (resURL != null) {
                return resURL.toURI();
            }
        }
        catch (URISyntaxException e) {
            log.error(e.getMessage());
        }
        String classPath = System.getProperty("java.class.path");
        for (String element : pathElements = classPath.split(File.pathSeparator)) {
            File newFile = new File(element, fileName);
            if (!newFile.exists()) continue;
            return newFile.toURI();
        }
        log.error("Unable to find {} in classpath", (Object)fileName);
        return null;
    }

    public static URI getConfigurationURI() {
        return ConfigurationManager.getConfigurationURI(CONFIG_FILE);
    }

    @Generated
    public Config getConfiguration() {
        return this.configuration;
    }
}

