/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.config;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.entrystore.config.Config;
import org.entrystore.config.DurationStyle;
import org.entrystore.repository.config.SortedProperties;

public class PropertiesConfiguration
implements Config {
    Log log = LogFactory.getLog(PropertiesConfiguration.class);
    private final SortedProperties config;
    private final PropertyChangeSupport pcs;
    private final String configName;
    private boolean modified = false;

    public PropertiesConfiguration(String configName) {
        this.configName = configName;
        this.config = new SortedProperties();
        this.pcs = new PropertyChangeSupport(this);
    }

    private void setModified(boolean modified) {
        this.modified = modified;
    }

    private void checkFirePropertyChange(String key, Object oldValue, Object newValue) {
        if (oldValue == null && newValue != null) {
            this.pcs.firePropertyChange(key, null, newValue);
        } else if (oldValue != null && !oldValue.equals(newValue)) {
            this.pcs.firePropertyChange(key, oldValue, newValue);
        }
    }

    private String numberedKey(String key, int number) {
        return key + "." + number;
    }

    private int getPropertyValueCount(String key) {
        int valueCount = 0;
        if (this.config.containsKey(key)) {
            valueCount = 1;
        } else {
            while (this.config.containsKey(this.numberedKey(key, valueCount + 1))) {
                ++valueCount;
            }
        }
        return valueCount;
    }

    private synchronized void addPropertyValue(String key, Object value) {
        int valueCount = this.getPropertyValueCount(key);
        if (valueCount == 1 && this.config.containsKey(key)) {
            String oldValue = this.config.getProperty(key);
            this.config.remove(key);
            this.config.setProperty(this.numberedKey(key, 1), oldValue);
            this.config.setProperty(this.numberedKey(key, 2), value.toString());
        } else if (valueCount > 1) {
            this.config.setProperty(this.numberedKey(key, valueCount + 1), value.toString());
        } else if (valueCount == 0) {
            this.config.setProperty(key, value.toString());
        }
    }

    private void addPropertyValues(String key, List values) {
        this.addPropertyValues(key, values.iterator());
    }

    private synchronized void addPropertyValues(String key, Iterator it) {
        while (it.hasNext()) {
            this.addPropertyValue(key, it.next());
        }
    }

    private synchronized List<String> getPropertyValues(String key) {
        int valueCount = this.getPropertyValueCount(key);
        ArrayList<String> result = new ArrayList<String>();
        if (valueCount == 1) {
            String value = this.config.getProperty(key);
            if (value == null) {
                value = this.config.getProperty(this.numberedKey(key, 1));
            }
            if (value != null) {
                result.add(value);
            }
        } else {
            for (int i = 1; i <= valueCount; ++i) {
                result.add(this.config.getProperty(this.numberedKey(key, i)));
            }
        }
        return result;
    }

    private synchronized void clearPropertyValues(String key) {
        int valueCount = this.getPropertyValueCount(key);
        if (valueCount > 1) {
            for (int i = 1; i <= valueCount; ++i) {
                this.config.remove(this.numberedKey(key, i));
            }
        }
        this.config.remove(key);
    }

    private void setPropertyValues(String key, List values) {
        this.setPropertyValues(key, values.iterator());
    }

    private synchronized void setPropertyValues(String key, Iterator it) {
        this.clearPropertyValues(key);
        this.addPropertyValues(key, it);
    }

    public void clear() {
        this.config.clear();
        this.setModified(true);
    }

    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    public boolean isModified() {
        return this.modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL configURL) throws IOException {
        try (InputStreamReader isr = null;){
            URL escapedURL = new URI(configURL.toString().replaceAll(" ", "%20")).toURL();
            isr = new InputStreamReader(escapedURL.openStream(), StandardCharsets.UTF_8);
            this.config.load(isr);
        }
    }

    public void save(URL configURL) throws IOException {
        try {
            String escapedURL = configURL.toString().replaceAll(" ", "%20");
            URI url = new URI(escapedURL);
            File file = new File(url);
            OutputStreamWriter output = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            this.config.store(output, this.configName);
            output.close();
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        this.setModified(false);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String key, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(key, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String key, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(key, listener);
    }

    public void clearProperty(String key) {
        int valueCount = this.getPropertyValueCount(key);
        Object oldValue = null;
        if (valueCount == 0) {
            return;
        }
        if (valueCount == 1) {
            oldValue = this.getString(key);
        } else if (valueCount > 1) {
            oldValue = this.getStringList(key);
        }
        this.clearPropertyValues(key);
        this.setModified(true);
        this.checkFirePropertyChange(key, oldValue, null);
    }

    public void addProperty(String key, Object value) {
        this.addPropertyValue(key, value);
        this.setModified(true);
        this.pcs.firePropertyChange(key, null, value);
    }

    public void addProperties(String key, List values) {
        this.addPropertyValues(key, values);
        this.setModified(true);
        this.pcs.firePropertyChange(key, null, values);
    }

    public void addProperties(String key, Iterator values) {
        this.addPropertyValues(key, values);
        this.setModified(true);
        this.pcs.firePropertyChange(key, null, values);
    }

    public void setProperty(String key, Object value) {
        String oldValue = this.getString(key);
        this.config.setProperty(key, value.toString());
        this.setModified(true);
        this.checkFirePropertyChange(key, oldValue, value);
    }

    public void setProperties(String key, List values) {
        List<String> oldValues = this.getStringList(key);
        this.setPropertyValues(key, values);
        this.setModified(true);
        this.checkFirePropertyChange(key, oldValues, values);
    }

    public void setProperties(String key, Iterator values) {
        List<String> oldValues = this.getStringList(key);
        this.setPropertyValues(key, values);
        this.setModified(true);
        this.checkFirePropertyChange(key, oldValues, values);
    }

    public boolean containsKey(String key) {
        return this.config.containsKey(key);
    }

    public List<String> getKeyList() {
        return this.getKeyList(null);
    }

    public List<String> getKeyList(String prefix) {
        Enumeration<?> keyIterator = this.config.propertyNames();
        ArrayList<String> result = new ArrayList<String>();
        while (keyIterator.hasMoreElements()) {
            String next = (String)keyIterator.nextElement();
            if (prefix != null && !next.startsWith(prefix)) continue;
            result.add(next);
        }
        return result;
    }

    public String getString(String key) {
        return this.config.getProperty(key);
    }

    public String getString(String key, String defaultValue) {
        return this.config.getProperty(key, defaultValue);
    }

    public List<String> getStringList(String key) {
        return this.getPropertyValues(key);
    }

    public List<String> getStringList(String key, List<String> defaultValues) {
        List<String> result = this.getPropertyValues(key);
        if (result.isEmpty()) {
            result = defaultValues;
        }
        return result;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String strValue = this.config.getProperty(key);
        if ("on".equalsIgnoreCase(strValue)) {
            return true;
        }
        if ("off".equalsIgnoreCase(strValue)) {
            return false;
        }
        if (strValue != null) {
            return Boolean.parseBoolean(strValue);
        }
        return defaultValue;
    }

    public byte getByte(String key) {
        String strValue = this.config.getProperty(key);
        byte byteValue = 0;
        if (strValue != null) {
            byteValue = Byte.parseByte(strValue);
        }
        return byteValue;
    }

    public byte getByte(String key, byte defaultValue) {
        String strValue = this.config.getProperty(key);
        byte byteValue = strValue != null ? Byte.parseByte(strValue) : defaultValue;
        return byteValue;
    }

    public double getDouble(String key) {
        String strValue = this.config.getProperty(key);
        double doubleValue = 0.0;
        if (strValue != null) {
            doubleValue = Double.parseDouble(strValue);
        }
        return doubleValue;
    }

    public double getDouble(String key, double defaultValue) {
        String strValue = this.config.getProperty(key);
        double doubleValue = strValue != null ? Double.parseDouble(strValue) : defaultValue;
        return doubleValue;
    }

    public float getFloat(String key) {
        String strValue = this.config.getProperty(key);
        float floatValue = 0.0f;
        if (strValue != null) {
            floatValue = Float.parseFloat(strValue);
        }
        return floatValue;
    }

    public float getFloat(String key, float defaultValue) {
        String strValue = this.config.getProperty(key);
        float floatValue = strValue != null ? Float.parseFloat(strValue) : defaultValue;
        return floatValue;
    }

    public int getInt(String key) {
        String strValue = this.config.getProperty(key);
        int intValue = 0;
        if (strValue != null) {
            intValue = Integer.parseInt(strValue);
        }
        return intValue;
    }

    public int getInt(String key, int defaultValue) {
        String strValue = this.config.getProperty(key);
        int intValue = strValue != null ? Integer.parseInt(strValue) : defaultValue;
        return intValue;
    }

    public long getLong(String key) {
        String strValue = this.config.getProperty(key);
        long longValue = 0L;
        if (strValue != null) {
            longValue = Long.parseLong(strValue);
        }
        return longValue;
    }

    public long getLong(String key, long defaultValue) {
        String strValue = this.config.getProperty(key);
        long longValue = strValue != null ? Long.parseLong(strValue) : defaultValue;
        return longValue;
    }

    public short getShort(String key) {
        String strValue = this.config.getProperty(key);
        short shortValue = 0;
        if (strValue != null) {
            shortValue = Short.parseShort(strValue);
        }
        return shortValue;
    }

    public short getShort(String key, short defaultValue) {
        String strValue = this.config.getProperty(key);
        short shortValue = strValue != null ? Short.parseShort(strValue) : defaultValue;
        return shortValue;
    }

    public URI getURI(String key) {
        try {
            String uri = this.config.getProperty(key);
            if (uri != null) {
                return new URI(uri);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public URI getURI(String key, URI defaultValue) {
        URI result = this.getURI(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public URL getURL(String key) {
        try {
            String uri = this.config.getProperty(key);
            if (uri != null) {
                return new URI(uri).toURL();
            }
        }
        catch (MalformedURLException | URISyntaxException exception) {
            // empty catch block
        }
        return null;
    }

    public URL getURL(String key, URL defaultValue) {
        URL result = this.getURL(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public Color getColor(String key) {
        Color result = null;
        String value = this.getString(key);
        if (value != null) {
            try {
                if (!value.startsWith("0x")) {
                    result = Color.decode(value);
                } else {
                    int rgb = Long.decode(value).intValue();
                    result = new Color(rgb);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public Color getColor(String key, Color defaultValue) {
        Color result = this.getColor(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public Duration getDuration(String key) {
        String durationString = this.config.getProperty(key);
        if (durationString == null) {
            return null;
        }
        return DurationStyle.detectAndParse((String)durationString);
    }

    public Duration getDuration(String key, Duration defaultValue) {
        String durationString = this.config.getProperty(key);
        if (durationString == null) {
            return defaultValue;
        }
        return DurationStyle.detectAndParse((String)durationString);
    }

    public Duration getDuration(String key, String defaultValue) {
        String durationString = this.config.getProperty(key);
        if (durationString == null) {
            return DurationStyle.detectAndParse((String)defaultValue);
        }
        return DurationStyle.detectAndParse((String)durationString);
    }

    public Duration getDuration(String key, long defaultValue) {
        String durationString = this.config.getProperty(key);
        if (durationString == null) {
            return Duration.ofMillis(defaultValue);
        }
        return DurationStyle.detectAndParse((String)durationString);
    }

    public Properties getProperties() {
        return this.config;
    }
}

