/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.security;

import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.entrystore.config.Config;
import org.entrystore.repository.config.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Password {
    private static final Logger log = LoggerFactory.getLogger(Password.class);
    private static final int iterations = 10240;
    private static final int saltLen = 16;
    private static final int desiredKeyLen = 192;
    public static final int PASSWORD_MAX_LENGTH = 2048;
    private static SecureRandom random;
    private static SecretKeyFactory secretKeyFactory;
    private static Rules rules;
    private static final Rules defaultRules;

    public static String getSaltedHash(String password) {
        Password.checkMinimumRequirements(password);
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return Base64.encodeBase64String((byte[])salt) + "$" + Password.hash(password, salt);
    }

    public static boolean check(String password, String stored) {
        Password.checkMinimumRequirements(password);
        if (stored == null) {
            throw new IllegalArgumentException("Stored password must not be null");
        }
        String[] saltAndPass = stored.split("\\$");
        if (saltAndPass.length != 2) {
            return false;
        }
        String hashOfInput = Password.hash(password, Base64.decodeBase64((String)saltAndPass[0]));
        if (hashOfInput != null) {
            return hashOfInput.equals(saltAndPass[1]);
        }
        return false;
    }

    private static String hash(String password, byte[] salt) {
        Password.checkMinimumRequirements(password);
        try {
            long before = new Date().getTime();
            SecretKey key = secretKeyFactory.generateSecret(new PBEKeySpec(password.toCharArray(), salt, 10240, 192));
            log.info("Password hashing took {} ms", (Object)(new Date().getTime() - before));
            return Base64.encodeBase64String((byte[])key.getEncoded());
        }
        catch (GeneralSecurityException gse) {
            log.error(gse.getMessage());
            return null;
        }
    }

    public static String sha256(String s) {
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA-256");
            digester.update(s.getBytes(StandardCharsets.UTF_8));
            byte[] key = digester.digest();
            SecretKeySpec spec = new SecretKeySpec(key, "AES");
            return Base64.encodeBase64String((byte[])spec.getEncoded());
        }
        catch (NoSuchAlgorithmException nsae) {
            log.error(nsae.getMessage());
            return null;
        }
    }

    private static void checkMinimumRequirements(String password) {
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("Empty passwords are not supported");
        }
        if (password.length() > 2048) {
            throw new IllegalArgumentException("The length of the password must not exceed 2048 characters");
        }
    }

    public static boolean conformsToRules(String password) {
        try {
            Password.checkMinimumRequirements(password);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        if (rules == null) {
            rules = defaultRules;
        }
        if (password.length() < rules.getMinLength()) {
            return false;
        }
        if (rules.isUppercase() && !Password.containsUpperCase(password)) {
            return false;
        }
        if (rules.isLowercase() && !Password.containsLowerCase(password)) {
            return false;
        }
        if (rules.isNumber() && !Password.containsNumber(password)) {
            return false;
        }
        if (rules.isSymbol() && !Password.containsSymbol(password)) {
            return false;
        }
        if (rules.getCustom() != null) {
            for (String expression : rules.getCustom()) {
                if (expression.isEmpty() || Pattern.compile(expression).matcher(password).find()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean containsLowerCase(String value) {
        return Password.contains(value, i -> Character.isLetter(i) && Character.isLowerCase(i));
    }

    private static boolean containsUpperCase(String value) {
        return Password.contains(value, i -> Character.isLetter(i) && Character.isUpperCase(i));
    }

    private static boolean containsNumber(String value) {
        return Password.contains(value, Character::isDigit);
    }

    private static boolean containsSymbol(String value) {
        return Pattern.compile("[^a-zA-Z\\d]").matcher(value).find();
    }

    private static boolean contains(String value, IntPredicate predicate) {
        return value.chars().anyMatch(predicate);
    }

    public static void loadRules(Config config) {
        rules = new Rules();
        Password.rules.lowercase = config.getBoolean(Settings.AUTH_PASSWORD_RULE_LOWERCASE, defaultRules.isLowercase());
        Password.rules.uppercase = config.getBoolean(Settings.AUTH_PASSWORD_RULE_UPPERCASE, defaultRules.isUppercase());
        Password.rules.number = config.getBoolean(Settings.AUTH_PASSWORD_RULE_NUMBER, defaultRules.isNumber());
        Password.rules.symbol = config.getBoolean(Settings.AUTH_PASSWORD_RULE_SYMBOL, defaultRules.isSymbol());
        Password.rules.minLength = config.getInt(Settings.AUTH_PASSWORD_RULE_MINLENGTH, defaultRules.getMinLength());
        Password.rules.custom = Sets.newHashSet((Iterable)config.getStringList(Settings.AUTH_PASSWORD_RULE_CUSTOM));
    }

    @Generated
    public static Rules getRules() {
        return rules;
    }

    @Generated
    public static void setRules(Rules rules) {
        Password.rules = rules;
    }

    @Generated
    public static Rules getDefaultRules() {
        return defaultRules;
    }

    static {
        defaultRules = new Rules(true, true, false, true, 10, null);
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
            secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            long before = new Date().getTime();
            random.setSeed(random.generateSeed(16));
            log.info("Seeding of SecureRandom took {} ms", (Object)(new Date().getTime() - before));
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage());
        }
    }

    public static class Rules {
        boolean uppercase;
        boolean lowercase;
        boolean symbol;
        boolean number;
        int minLength;
        Set<String> custom;

        @Generated
        public Rules(boolean uppercase, boolean lowercase, boolean symbol, boolean number, int minLength, Set<String> custom) {
            this.uppercase = uppercase;
            this.lowercase = lowercase;
            this.symbol = symbol;
            this.number = number;
            this.minLength = minLength;
            this.custom = custom;
        }

        @Generated
        public boolean isUppercase() {
            return this.uppercase;
        }

        @Generated
        public boolean isLowercase() {
            return this.lowercase;
        }

        @Generated
        public boolean isSymbol() {
            return this.symbol;
        }

        @Generated
        public boolean isNumber() {
            return this.number;
        }

        @Generated
        public int getMinLength() {
            return this.minLength;
        }

        @Generated
        public Set<String> getCustom() {
            return this.custom;
        }

        @Generated
        public Rules() {
        }
    }
}

