/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.test;

import java.net.URI;
import java.util.HashSet;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.entrystore.Context;
import org.entrystore.ContextManager;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.Group;
import org.entrystore.PrincipalManager;
import org.entrystore.ResourceType;
import org.entrystore.User;
import org.entrystore.impl.RepositoryManagerImpl;
import org.entrystore.impl.RepositoryProperties;
import org.entrystore.repository.RepositoryException;
import org.entrystore.repository.RepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuite {
    static Logger log = LoggerFactory.getLogger(TestSuite.class);
    public static final String NSDCTERMS = "http://purl.org/dc/terms/";
    public static final String NSbase = "http://entrystore.org/terms/";
    public static final IRI dc_title;
    public static final IRI dc_description;
    public static final IRI dc_subject;
    public static final IRI dc_format;
    public static final IRI scam_name;
    public static final IRI scam_email;
    public static final IRI scam_type;
    public static final IRI scam_group;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDisneySuite(RepositoryManager rm) {
        PrincipalManager pm = rm.getPrincipalManager();
        ContextManager cm = rm.getContextManager();
        URI currentUserURI = pm.getAuthenticatedUserURI();
        pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
        try {
            Entry donaldE = pm.createResource(null, GraphType.User, null, null);
            pm.setPrincipalName(donaldE.getResourceURI(), "Donald");
            TestSuite.setMetadata(donaldE, "Donald Duck", "I am easily provoked and have an occasionally explosive temper, so thread carefully around me.", "duck", null, null);
            User donald = (User)donaldE.getResource();
            donald.setSecret("donaldDonald12");
            Entry daisyE = pm.createResource(null, GraphType.User, null, null);
            pm.setPrincipalName(daisyE.getResourceURI(), "Daisy");
            TestSuite.setMetadata(daisyE, "Daisy Duck", "I am Donald's girlfriend, but I am far more sophisticated!", "duck", null, null);
            User daisy = (User)daisyE.getResource();
            daisy.setSecret("daisyDaisy34");
            Entry mickeyE = pm.createResource(null, GraphType.User, null, null);
            pm.setPrincipalName(mickeyE.getResourceURI(), "Mickey");
            TestSuite.setMetadata(mickeyE, "Mickey Mouse", "I am older than I look although I still speek in a famously shy, falsetto voice.", "mouse", null, null);
            User mickey = (User)mickeyE.getResource();
            mickey.setSecret("mickeyMickey56");
            Entry friendsOfMickeyE = pm.createResource(null, GraphType.Group, null, null);
            pm.setPrincipalName(friendsOfMickeyE.getResourceURI(), "friendsOfMickey");
            TestSuite.setMetadata(friendsOfMickeyE, "Old friends of Mickey", null, null, null, null);
            friendsOfMickeyE.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, pm.getGuestUser().getURI());
            Group friendsOfMickey = (Group)friendsOfMickeyE.getResource();
            friendsOfMickey.addMember(donald);
            friendsOfMickey.addMember(mickey);
            Entry duckE = cm.createResource(null, GraphType.Context, null, null);
            TestSuite.setMetadata(duckE, "Donald and Daisy Duck's place", "Scrooge has a vault, we have this.", null, null, null);
            duckE.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, pm.getGuestUser().getURI());
            Context duck = (Context)duckE.getResource();
            cm.setName(duckE.getResource().getURI(), "duck");
            duckE.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.Administer, donald.getURI());
            duckE.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.Administer, daisy.getURI());
            duckE.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, pm.getGuestUser().getURI());
            duckE.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadResource, pm.getGuestUser().getURI());
            donald.setHomeContext(duck);
            Entry mouseE = cm.createResource(null, GraphType.Context, null, null);
            TestSuite.setMetadata(mouseE, "Mickey Mouse's place", "Mickey's creephole with old cheese and other goodies.", "mouse", null, null);
            mouseE.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, pm.getGuestUser().getURI());
            Context mouse = (Context)mouseE.getResource();
            cm.setName(mouseE.getResource().getURI(), "mouse");
            mouseE.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.Administer, mickey.getURI());
            mouseE.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadResource, friendsOfMickey.getURI());
            mouseE.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.WriteResource, friendsOfMickey.getURI());
            mickey.setHomeContext(mouse);
            Entry emptyMd = pm.createResource(null, GraphType.User, null, null);
            log.info("Created user without metadata: {}", (Object)emptyMd.getEntryURI().toString());
        }
        finally {
            pm.setAuthenticatedUserURI(currentUserURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTestEntriesInDisneySuite(RepositoryManager rm) {
        ContextManager cm = rm.getContextManager();
        PrincipalManager pm = rm.getPrincipalManager();
        URI currentUserURI = pm.getAuthenticatedUserURI();
        pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
        try {
            Context duck = cm.getContext("duck");
            Context mouse = cm.getContext("mouse");
            duck.createResource(null, GraphType.List, null, null);
            mouse.createResource(null, GraphType.List, null, null);
        }
        finally {
            pm.setAuthenticatedUserURI(currentUserURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntriesInDisneySuite(RepositoryManager rm) {
        ContextManager cm = rm.getContextManager();
        PrincipalManager pm = rm.getPrincipalManager();
        URI currentUserURI = pm.getAuthenticatedUserURI();
        pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
        try {
            Context duck = cm.getContext("duck");
            Context mouse = cm.getContext("mouse");
            User Mickey = (User)pm.getPrincipalEntry("Mickey").getResource();
            Entry linkToDaisyEntry = mouse.createLink(null, URI.create("http://en.wikipedia.org/wiki/Daisy_Duck"), null);
            TestSuite.setMetadata(linkToDaisyEntry, "Donalds girlfriend", "Seriously Donald, you have been dating this girl for ages, isn't it time to make the move soon?", "duck", null, null);
            Entry linkToDonaldEntry = mouse.createLink(null, URI.create("http://en.wikipedia.org/wiki/Donald_Duck"), null);
            HashSet<URI> mdRead = new HashSet<URI>();
            mdRead.add(pm.getPrincipalEntry("Daisy").getResourceURI());
            linkToDonaldEntry.setAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, mdRead);
            TestSuite.setMetadata(linkToDonaldEntry, "Donald the man", "Daisy, Donald is a really nice chap, maybe you two should get married soon?", "duck", null, null);
            Entry linkEntry = duck.createReference(null, Mickey.getURI(), Mickey.getEntry().getLocalMetadataURI(), null);
            linkEntry.setGraphType(GraphType.User);
            Entry subListEntry = duck.createResource(null, GraphType.List, null, null);
            TestSuite.setMetadata(subListEntry, "Material", "Mixed material.", null, null, null);
            Entry nephews = duck.createLink(null, URI.create("http://en.wikipedia.org/wiki/Huey%2C_Dewey%2C_and_Louie"), subListEntry.getResourceURI());
            TestSuite.setMetadata(nephews, "Huey, Dewey, and Louie", "These are Donalds sister Dumbellas children.", "nephew", null, null);
            Entry familyTree = duck.createLink(null, URI.create("http://en.wikipedia.org/wiki/Duck_Family_Tree"), subListEntry.getResourceURI());
            TestSuite.setMetadata(familyTree, "Family tree", "The duck family from Dingus to Donald, Daisy is not in there yet...", "family", null, null);
            Entry phooey = duck.createResource(null, GraphType.None, ResourceType.NamedResource, null);
            TestSuite.setMetadata(phooey, "Phooey Duck", "A mysterius fourth nephew, a freak of nature. Drawn by accident?", "nephew", null, null);
            Entry image = duck.createResource(null, GraphType.None, ResourceType.InformationResource, null);
            TestSuite.setMetadata(image, "An image", "A image, remains to be uploaded.", null, "image/jpeg", null);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            pm.setAuthenticatedUserURI(currentUserURI);
        }
    }

    public static void setMetadata(Entry entry, String title, String desc, String subj, String format, String type) {
        Model graph = entry.getLocalMetadata().getGraph();
        IRI root = Values.iri((String)entry.getResourceURI().toString());
        try {
            graph.add((Resource)root, dc_title, (Value)Values.literal((String)title, (String)"en"), new Resource[0]);
            if (desc != null) {
                graph.add((Resource)root, dc_description, (Value)Values.literal((String)desc, (String)"en"), new Resource[0]);
            }
            if (subj != null) {
                graph.add((Resource)root, dc_subject, (Value)Values.literal((String)subj), new Resource[0]);
            }
            if (format != null) {
                graph.add((Resource)root, dc_format, (Value)Values.literal((String)format), new Resource[0]);
            }
            if (type != null) {
                graph.add((Resource)root, scam_type, (Value)Values.literal((String)type), new Resource[0]);
            }
            entry.getLocalMetadata().setGraph(graph);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public static void addGuestToMetadataACL(Entry entry) {
        Model g = entry.getGraph();
        g.add((Resource)Values.iri((String)entry.getLocalMetadataURI().toString()), RepositoryProperties.Read, (Value)Values.iri((String)entry.getRepositoryManager().getPrincipalManager().getGuestUser().getURI().toString()), new Resource[]{Values.iri((String)entry.getEntryURI().toString())});
        entry.setGraph(g);
    }

    public static void removeGuestFromMetadataACL(Entry entry) {
        LinkedHashModel m = new LinkedHashModel(entry.getGraph());
        m.remove((Resource)Values.iri((String)entry.getLocalMetadataURI().toString()), RepositoryProperties.Read, (Value)Values.iri((String)entry.getRepositoryManager().getPrincipalManager().getGuestUser().getURI().toString()), new Resource[]{Values.iri((String)entry.getEntryURI().toString())});
        entry.setGraph((Model)new LinkedHashModel((Model)m));
    }

    public static void HarvesterTestSuite(RepositoryManagerImpl rm, PrincipalManager pm, ContextManager cm) {
        URI currentUserURI = pm.getAuthenticatedUserURI();
        pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
        pm.setAuthenticatedUserURI(currentUserURI);
    }

    static {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        dc_title = vf.createIRI("http://purl.org/dc/terms/title");
        dc_description = vf.createIRI("http://purl.org/dc/terms/description");
        dc_subject = vf.createIRI("http://purl.org/dc/terms/subject");
        dc_format = vf.createIRI("http://purl.org/dc/terms/format");
        scam_name = vf.createIRI("http://entrystore.org/terms/name");
        scam_email = vf.createIRI("http://entrystore.org/terms/email");
        scam_type = vf.createIRI("http://entrystore.org/terms/type");
        scam_group = vf.createIRI("http://entrystore.org/terms/group");
    }
}

