/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.transformation;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.entrystore.Context;
import org.entrystore.Data;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.List;
import org.entrystore.ResourceType;
import org.entrystore.repository.util.FileOperations;

public class ZipExport {
    public static final IRI DCtitle;
    public static final IRI DCTermstitle;
    public static final String DCbase = "http://purl.org/dc/elements/1.1/";
    public static final String DCTermsbase = "http://purl.org/dc/terms/";
    private Context context;
    private Set<Entry> visited = new HashSet<Entry>();
    private File dir;

    public ZipExport(Context contextToExport, String exportPath) {
        this.context = contextToExport;
        if (exportPath != null) {
            this.dir = new File(exportPath);
            this.dir.mkdirs();
        }
        if (this.dir == null || !this.dir.exists()) {
            try {
                this.dir = FileOperations.createTempDirectory("toZip", null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void export() {
        Entry top = this.context.get("_top");
        this.visited.add(top);
        this.recurse(this.dir, top);
    }

    protected void recurse(File parentFile, Entry folderEntry) {
        File folderFile = new File(parentFile, this.getLabel(folderEntry));
        folderFile.mkdirs();
        List folderList = (List)folderEntry.getResource();
        for (URI child : folderList.getChildren()) {
            Entry childEntry = this.context.getByEntryURI(child);
            if (childEntry == null) continue;
            if (this.visited.contains(childEntry)) {
                return;
            }
            this.visited.add(childEntry);
            if (this.isFile(childEntry)) {
                File childFile = new File(folderFile, this.getLabel(childEntry));
                Data data = (Data)childEntry.getResource();
                try {
                    FileOperations.copyFile(data.getDataFile(), childFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (this.isLocalDir(childEntry)) {
                this.recurse(folderFile, childEntry);
                continue;
            }
            System.out.println("HELP!!!");
        }
    }

    protected boolean isFile(Entry entry) {
        return entry.getEntryType() == EntryType.Local && entry.getGraphType() == GraphType.None && entry.getResourceType() == ResourceType.InformationResource;
    }

    protected boolean isLocalDir(Entry entry) {
        return entry.getEntryType() == EntryType.Local && entry.getGraphType() == GraphType.List;
    }

    protected String getLabel(Entry entry) {
        String label = this.getLabelUnfiltered(entry);
        return label.replace('/', '-');
    }

    protected String getLabelUnfiltered(Entry entry) {
        String filename;
        if (this.isFile(entry) && (filename = entry.getFilename()) != null) {
            return filename;
        }
        Iterator it = entry.getLocalMetadata().getGraph().filter(null, DCtitle, null, new Resource[0]).iterator();
        if (it.hasNext()) {
            return ((Statement)it.next()).getObject().stringValue();
        }
        it = entry.getLocalMetadata().getGraph().filter(null, DCTermstitle, null, new Resource[0]).iterator();
        if (it.hasNext()) {
            return ((Statement)it.next()).getObject().stringValue();
        }
        return entry.getId();
    }

    static {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        DCtitle = vf.createIRI("http://purl.org/dc/elements/1.1/title");
        DCTermstitle = vf.createIRI("http://purl.org/dc/terms/title");
    }
}

