/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.entrystore.Context;
import org.entrystore.ContextManager;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.Metadata;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.impl.RepositoryProperties;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.util.EntryUtil;
import org.entrystore.repository.util.NS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCorrection {
    private static final Logger log = LoggerFactory.getLogger(DataCorrection.class);
    private PrincipalManager pm;
    private ContextManager cm;

    public DataCorrection(RepositoryManager rm) {
        this.pm = rm.getPrincipalManager();
        this.cm = rm.getContextManager();
    }

    public static String createW3CDTF(Date date) {
        SimpleDateFormat W3CDTF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        return W3CDTF.format(date);
    }

    private Set<URI> getContexts() {
        HashSet<URI> contexts = new HashSet<URI>();
        Set aliases = this.cm.getNames();
        for (String contextAlias : aliases) {
            URI contextURI = this.cm.getContextURI(contextAlias);
            contexts.add(contextURI);
        }
        if (contexts.contains(null)) {
            contexts.remove(null);
        }
        return contexts;
    }

    private List<Entry> getEntries(Set<URI> contexts) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (URI uri : contexts) {
            if (uri == null) continue;
            String contextURI = uri.toString();
            String contextId = contextURI.substring(contextURI.toString().lastIndexOf("/") + 1);
            Context context = this.cm.getContext(contextId);
            Set contextEntries = context.getEntries();
            for (URI entryURI : contextEntries) {
                String entryId = entryURI.toString().substring(entryURI.toString().lastIndexOf("/") + 1);
                Entry entry = context.get(entryId);
                if (entry == null) {
                    log.warn("No entry found for URI: " + String.valueOf(entryURI));
                    continue;
                }
                entries.add(entry);
            }
        }
        return entries;
    }

    private void fixMetadataOfPrincipal(Entry entry) {
        if (entry == null) {
            return;
        }
        Model metadata = entry.getGraph();
        if (metadata != null) {
            IRI resourceURI = Values.iri((String)entry.getResourceURI().toString());
            IRI metadataURI = Values.iri((String)entry.getLocalMetadata().getURI().toString());
            Statement resourceRights = Values.getValueFactory().createStatement((Resource)resourceURI, Values.iri((String)NS.entrystore, (String)"write"), (Value)resourceURI);
            Statement metadataRights = Values.getValueFactory().createStatement((Resource)metadataURI, Values.iri((String)NS.entrystore, (String)"write"), (Value)resourceURI);
            if (!metadata.filter(resourceRights.getSubject(), resourceRights.getPredicate(), resourceRights.getObject(), new Resource[0]).iterator().hasNext()) {
                metadata.add((Object)resourceRights);
                log.info("Added statement: " + String.valueOf(resourceRights));
            }
            if (!metadata.filter(metadataRights.getSubject(), metadataRights.getPredicate(), metadataRights.getObject(), new Resource[0]).iterator().hasNext()) {
                metadata.add((Object)metadataRights);
                log.info("Added statement: " + String.valueOf(metadataRights));
            }
            entry.setGraph(metadata);
        }
    }

    private void fixMetadataOfEntry(Entry entry) {
        Model metadata;
        Metadata localMd = entry.getLocalMetadata();
        if (localMd != null && (metadata = entry.getLocalMetadata().getGraph()) != null) {
            boolean updateNecessary = false;
            URI rURI = entry.getResourceURI();
            if (rURI == null) {
                log.error("Resource URI is null!");
                return;
            }
            IRI resURI = Values.iri((String)rURI.toString());
            ArrayList<Statement> toRemove = new ArrayList<Statement>();
            ArrayList<Statement> toAdd = new ArrayList<Statement>();
            for (Statement rdfsTypeStmnt : metadata.filter(null, Values.iri((String)"http://www.w3.org/TR/rdf-schema/type"), null, new Resource[0])) {
                String objValue;
                if (!(rdfsTypeStmnt.getObject() instanceof Resource) || !(objValue = rdfsTypeStmnt.getObject().stringValue()).startsWith("http://purl.org/telmap/") && !objValue.equals("http://http://xmlns.com/foaf/0.1/Person")) continue;
                toAdd.add(Values.getValueFactory().createStatement(rdfsTypeStmnt.getSubject(), RDF.TYPE, rdfsTypeStmnt.getObject()));
                toRemove.add(rdfsTypeStmnt);
            }
            if (!toAdd.isEmpty()) {
                log.info("ADD");
                for (Statement statement : toAdd) {
                    log.info(statement.toString());
                }
                if (!metadata.addAll(toAdd)) {
                    log.info("STRANGE: Graph not modified");
                } else {
                    updateNecessary = true;
                }
            }
            if (!toRemove.isEmpty()) {
                log.info("DEL");
                for (Statement statement : toRemove) {
                    log.info(statement.toString());
                }
                if (!metadata.removeAll(toRemove)) {
                    log.info("STRANGE: Graph not modified");
                } else {
                    updateNecessary = true;
                }
            }
            if (updateNecessary) {
                localMd.setGraph(metadata);
                log.info("----- Updated metadata of entry: " + String.valueOf(entry.getEntryURI()));
            }
        }
    }

    private static Set<Date> getStrangeDates(Entry entry) {
        Model metadata;
        HashSet<Date> result = new HashSet<Date>();
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        Date from = DataCorrection.parseDateFromStringStrict("1910-01-01");
        Date until = DataCorrection.parseDateFromStringStrict("2009-12-01");
        IRI dctermsDate = vf.createIRI(NS.dcterms + "date");
        IRI w3cdtf = vf.createIRI("http://purl.org/dc/terms/W3CDTF");
        Metadata localMd = entry.getLocalMetadata();
        if (localMd != null && (metadata = entry.getLocalMetadata().getGraph()) != null) {
            for (Statement statement : metadata.filter(null, dctermsDate, null, new Resource[0])) {
                Date date;
                Value obj = statement.getObject();
                if (!(obj instanceof Literal)) continue;
                Literal lit = (Literal)obj;
                if (!w3cdtf.equals((Object)lit.getDatatype())) {
                    log.info("STRANGE: incorrect datatype!");
                }
                if (!(date = DataCorrection.parseDateFromStringStrict(lit.stringValue())).before(from) && !date.after(until)) continue;
                result.add(date);
            }
        }
        return result;
    }

    private static Date parseDateFromStringStrict(String dateString) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date d = sdf.parse(dateString);
            return d;
        }
        catch (ParseException pe) {
            log.info(pe.getMessage());
            return null;
        }
    }

    private static String dateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    private static Date parseDateFromString(String dateString) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            Date d = sdf.parse(dateString);
            log.info("Matched: yyyy-MM-dd'T'HH:mm:ssZ :: " + dateString);
            return d;
        }
        catch (ParseException sdf) {
            HashSet<String> formats = new HashSet<String>();
            formats.add("dd MMMMM yyyy");
            formats.add("MMMMM yyyy");
            formats.add("dd.MM.yy");
            formats.add("dd/MM/yyyy");
            formats.add("dd-MM-yyyy");
            formats.add("dd-MMMMM-yyyy");
            formats.add("ddMMyyyy");
            formats.add("yyyy-MM-dd");
            SimpleDateFormat sdf2 = null;
            for (String format : formats) {
                sdf2 = new SimpleDateFormat(format, Locale.ENGLISH);
                try {
                    Date d = sdf2.parse(dateString);
                    log.info("Matched: " + format + " :: " + dateString);
                    return d;
                }
                catch (ParseException parseException) {
                }
            }
            try {
                sdf2 = new SimpleDateFormat("dd.MM.yyyy");
                Date d = sdf2.parse(dateString);
                log.info("Matched: dd.MM.yyyy :: " + dateString);
                return d;
            }
            catch (ParseException d) {
                try {
                    sdf2 = new SimpleDateFormat("MM/yyyy");
                    Date d2 = sdf2.parse(dateString);
                    log.info("Matched: MM/yyyy :: " + dateString);
                    return d2;
                }
                catch (ParseException d2) {
                    try {
                        sdf2 = new SimpleDateFormat("MM-yyyy");
                        Date d3 = sdf2.parse(dateString);
                        log.info("Matched: MM-yyyy :: " + dateString);
                        return d3;
                    }
                    catch (ParseException d3) {
                        try {
                            sdf2 = new SimpleDateFormat("yyyy-MM");
                            Date d4 = sdf2.parse(dateString);
                            log.info("Matched: yyyy-MM :: " + dateString);
                            return d4;
                        }
                        catch (ParseException d4) {
                            try {
                                sdf2 = new SimpleDateFormat("yyyy");
                                Date d5 = sdf2.parse(dateString);
                                log.info("Matched: yyyy :: " + dateString);
                                return d5;
                            }
                            catch (ParseException parseException) {
                                log.info("UNMATCHED: " + dateString);
                                return null;
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAllDates() {
        URI currentUser = this.pm.getAuthenticatedUserURI();
        FileWriter writer = null;
        try {
            writer = new FileWriter(new File("/home/hannes/Desktop/dates.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.pm.setAuthenticatedUserURI(this.pm.getAdminUser().getURI());
            List<Entry> entries = this.getEntries(this.getContexts());
            for (Entry entry : entries) {
                Set<Date> strangeDates = DataCorrection.getStrangeDates(entry);
                if (strangeDates.isEmpty()) continue;
                Object datesStr = "";
                for (Date date : strangeDates) {
                    datesStr = (String)datesStr + DataCorrection.dateToString(date) + ";";
                }
                String logMsg = "URI: " + String.valueOf(entry.getEntryURI()) + ", Title: \"" + EntryUtil.getTitle(entry, "en") + "\", suspicious date(s): " + (String)datesStr;
                log.info(logMsg);
                try {
                    writer.write(logMsg + "\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.pm.setAuthenticatedUserURI(currentUser);
        }
        try {
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixMetadataGlobally() {
        URI currentUser = this.pm.getAuthenticatedUserURI();
        try {
            this.pm.setAuthenticatedUserURI(this.pm.getAdminUser().getURI());
            List<Entry> entries = this.getEntries(this.getContexts());
            for (Entry entry : entries) {
                if (entry.getEntryType().equals((Object)EntryType.Reference)) continue;
                this.fixMetadataOfEntry(entry);
            }
        }
        finally {
            this.pm.setAuthenticatedUserURI(currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixPrincipalsGlobally() {
        URI currentUser = this.pm.getAuthenticatedUserURI();
        try {
            this.pm.setAuthenticatedUserURI(this.pm.getAdminUser().getURI());
            List users = this.pm.getUsers();
            for (User user : users) {
                Entry entry = user.getEntry();
                if (entry == null) continue;
                this.fixMetadataOfPrincipal(entry);
            }
        }
        finally {
            this.pm.setAuthenticatedUserURI(currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertPasswordsToHashes() {
        URI currentUser = this.pm.getAuthenticatedUserURI();
        try {
            this.pm.setAuthenticatedUserURI(this.pm.getAdminUser().getURI());
            List users = this.pm.getUsers();
            for (User user : users) {
                String secret = user.getSecret();
                if (secret == null) continue;
                log.warn("Replacing password with salted hashed password for user " + String.valueOf(user.getURI()));
                if (user.setSecret(secret)) continue;
                log.error("Unable to reset password of user " + String.valueOf(user.getURI()));
            }
        }
        finally {
            this.pm.setAuthenticatedUserURI(currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printFileNamesGlobally() {
        URI currentUser = this.pm.getAuthenticatedUserURI();
        try {
            this.pm.setAuthenticatedUserURI(this.pm.getAdminUser().getURI());
            List<Entry> entries = this.getEntries(this.getContexts());
            for (Entry entry : entries) {
                if (!entry.getEntryType().equals((Object)EntryType.Local) || entry.getFilename() == null) continue;
                log.info(entry.getFilename());
            }
        }
        finally {
            this.pm.setAuthenticatedUserURI(currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupTrackedDeletedEntries(Repository repository) {
        RepositoryConnection rc = null;
        try {
            rc = repository.getConnection();
            Date before = new Date();
            log.info("Performing cleanup of tracked deleted entries");
            long tripleCountBefore = rc.size(new Resource[0]);
            rc.begin();
            log.info("Removing all triples with predicate " + String.valueOf(RepositoryProperties.Deleted));
            rc.remove(rc.getStatements((Resource)null, RepositoryProperties.Deleted, (Value)null, false, new Resource[0]), new Resource[0]);
            log.info("Removing all triples with predicate " + String.valueOf(RepositoryProperties.DeletedBy));
            rc.remove(rc.getStatements((Resource)null, RepositoryProperties.DeletedBy, (Value)null, false, new Resource[0]), new Resource[0]);
            rc.commit();
            log.info("Cleanup removed " + (tripleCountBefore - rc.size(new Resource[0])) + " triples and took " + (new Date().getTime() - before.getTime()) + " ms");
        }
        catch (RepositoryException e) {
            try {
                rc.rollback();
            }
            catch (RepositoryException re) {
                log.error(re.getMessage());
            }
            log.error(e.getMessage());
        }
        finally {
            if (rc != null) {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }
}

