/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.entrystore.repository.util.HashType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hashing {
    private static final Logger log = LoggerFactory.getLogger(Hashing.class);

    private static String byteArrayToHexString(byte[] in) {
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        StringBuilder out = new StringBuilder(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            byte ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        return new String(out);
    }

    public static String hash(String source, HashType algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("Algorithm cannot be null or empty.");
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("Source cannot be null or empty.");
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm.toString());
            byte[] bytes = md.digest(source.getBytes());
            if (bytes == null || bytes.length < 1) {
                throw new IllegalArgumentException("Digest created empty bytes array.");
            }
            return Hashing.byteArrayToHexString(bytes);
        }
        catch (NoSuchAlgorithmException ex) {
            log.warn("{} not supported: {}. Returning non-hashed value.", (Object)algorithm, (Object)ex.getMessage());
            return source;
        }
    }
}

