/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.util;

import java.util.Map;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class InterceptingRDFInserter
extends AbstractRDFHandler {
    private RepositoryConnection rc;
    private Map<String, String> namespaces;
    private StatementModifier modifier;

    public InterceptingRDFInserter(RepositoryConnection rc) {
        this(rc, null);
    }

    public InterceptingRDFInserter(RepositoryConnection rc, StatementModifier modifier) {
        this.rc = rc;
        this.modifier = modifier;
    }

    public void handleStatement(Statement stmnt) throws RDFHandlerException {
        if (this.modifier != null) {
            stmnt = this.modifier.modifyStatement(stmnt);
        }
        try {
            this.rc.add(stmnt, new Resource[0]);
        }
        catch (RepositoryException re) {
            throw new RDFHandlerException((Throwable)re);
        }
    }

    public StatementModifier getStatementModifier() {
        return this.modifier;
    }

    public void setStatementModifier(StatementModifier modifier) {
        this.modifier = modifier;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        if (!this.namespaces.containsKey(prefix)) {
            this.namespaces.put(prefix, uri);
        }
    }

    public static interface StatementModifier {
        public Statement modifyStatement(Statement var1);
    }
}

