/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.util;

import java.net.URI;
import java.net.URL;
import java.util.StringTokenizer;
import lombok.Generated;
import org.entrystore.repository.util.URIType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URISplit {
    private static final Logger log = LoggerFactory.getLogger(URISplit.class);
    private static final String SLASH_DELIMITER = "/";
    private static final String URI_REGEX = "^_?[a-zA-Z0-9-_]+/?";
    private static final String URI_PARAMS_REGEX = "^_?[a-zA-Z0-9-_]+\\?\\S+";
    URIType uriType;
    String contextId;
    String id;
    String path;
    String base;
    boolean isContext = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URISplit(URI anyURI, URL baseURL) {
        if (!URISplit.isValidURI(anyURI)) return;
        this.base = baseURL.toString();
        if (anyURI.toString().startsWith(this.base)) {
            String anyURIWithoutBase = anyURI.toString().substring(this.base.length());
            StringTokenizer st = new StringTokenizer(anyURIWithoutBase, SLASH_DELIMITER);
            this.contextId = st.nextToken();
            if (st.hasMoreTokens()) {
                this.path = st.nextToken();
                if (!st.hasMoreTokens()) throw new IllegalArgumentException("URI is incompatible with EntryStore");
                this.id = st.nextToken();
            } else {
                if (anyURIWithoutBase.matches(URI_PARAMS_REGEX)) {
                    this.uriType = URIType.Unknown;
                    return;
                }
                if (!anyURIWithoutBase.matches(URI_REGEX)) {
                    throw new IllegalArgumentException("URI is malformed or encoded");
                }
                this.id = this.contextId;
                this.path = "resource";
                this.contextId = "_contexts";
                this.isContext = true;
            }
            this.uriType = this.path.equals("entry") ? URIType.MetaMetadata : (this.path.equals("metadata") ? URIType.Metadata : URIType.Resource);
            return;
        } else {
            this.uriType = URIType.Unknown;
        }
    }

    private static boolean isValidURI(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("URI is malformed or encoded");
        }
        return true;
    }

    private static String getBaseContextURIString(String base, String contextId) {
        if (base != null && contextId != null) {
            return base.concat(contextId);
        }
        return null;
    }

    public URI getContextURI() {
        String context = URISplit.getBaseContextURIString(this.base, this.contextId);
        if (context != null) {
            return URI.create(context);
        }
        return null;
    }

    public URI getContextMetaMetadataURI() {
        return URISplit.createURI(this.base, "_contexts", "entry", this.contextId);
    }

    public URI getMetaMetadataURI() {
        return URISplit.createURI(this.base, this.contextId, "entry", this.id);
    }

    public URI getMetadataURI() {
        return URISplit.createURI(this.base, this.contextId, "metadata", this.id);
    }

    public URI getResourceURI() {
        return this.isContext ? URISplit.createURI(this.base, this.id) : URISplit.createURI(this.base, this.contextId, "resource", this.id);
    }

    public static URI createURI(String base, String contextId, String path, String entryId) {
        URI uri;
        String uriString = URISplit.getBaseContextURIString(base, contextId);
        if (uriString == null || path == null || entryId == null) {
            log.warn("Parameters must not be null or empty in uri={} path={} entryId={}.", new Object[]{uriString, path, entryId});
        }
        if (URISplit.isValidURI(uri = URI.create(uriString + SLASH_DELIMITER + path + SLASH_DELIMITER + entryId))) {
            return uri;
        }
        throw new IllegalArgumentException("URI is malformed or encoded");
    }

    public static URI createURI(String base, String contextId) {
        URI uri = URI.create(base.concat(contextId));
        if (URISplit.isValidURI(uri)) {
            return uri;
        }
        throw new IllegalArgumentException("URI is malformed or encoded");
    }

    @Generated
    public URIType getUriType() {
        return this.uriType;
    }

    @Generated
    public String getContextId() {
        return this.contextId;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getBase() {
        return this.base;
    }

    @Generated
    public boolean isContext() {
        return this.isContext;
    }
}

