/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.config;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.entrystore.config.Config;

public class Configurations {
    private Configurations() {
    }

    public static Config synchronizedConfig(Config config) {
        return new SynchronizedConfiguration(config);
    }

    static class SynchronizedConfiguration
    implements Config {
        private final Object mutex;
        private final Config config;

        SynchronizedConfiguration(Config c) {
            if (c == null) {
                throw new IllegalArgumentException("Configuration must not be null");
            }
            this.config = c;
            this.mutex = this;
        }

        SynchronizedConfiguration(Config c, Object mutex) {
            if (c == null || mutex == null) {
                throw new IllegalArgumentException("Configuration must not be null");
            }
            this.config = c;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.config.addPropertyChangeListener(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPropertyChangeListener(String key, PropertyChangeListener listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.config.addPropertyChangeListener(key, listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.config.removePropertyChangeListener(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePropertyChangeListener(String key, PropertyChangeListener listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.config.removePropertyChangeListener(key, listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addProperties(String key, List values) {
            Object object = this.mutex;
            synchronized (object) {
                this.config.addProperties(key, values);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addProperties(String key, Iterator values) {
            Object object = this.mutex;
            synchronized (object) {
                this.config.addProperties(key, values);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addProperty(String key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                this.config.addProperty(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.config.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearProperty(String key) {
            Object object = this.mutex;
            synchronized (object) {
                this.config.clearProperty(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getBoolean(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getBoolean(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getBoolean(String key, boolean defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getBoolean(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte getByte(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getByte(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte getByte(String key, byte defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getByte(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getDouble(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getDouble(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getDouble(String key, double defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getDouble(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float getFloat(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getFloat(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float getFloat(String key, float defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getFloat(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInt(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getInt(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInt(String key, int defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getInt(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getKeyList() {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getKeyList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getKeyList(String prefix) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getKeyList(prefix);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLong(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getLong(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLong(String key, long defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getLong(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short getShort(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getShort(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short getShort(String key, short defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getShort(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URI getURI(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getURI(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URI getURI(String key, URI defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getURI(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URL getURL(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getURL(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URL getURL(String key, URL defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getURL(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Color getColor(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getColor(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Color getColor(String key, Color defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getColor(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getString(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getString(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getString(String key, String defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getString(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getStringList(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getStringList(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getStringList(String key, List defaultValues) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getStringList(key, defaultValues);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Duration getDuration(String key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getDuration(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Duration getDuration(String key, Duration defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getDuration(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Duration getDuration(String key, String defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getDuration(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Duration getDuration(String key, long defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getDuration(key, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isModified() {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.isModified();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load(URL configURL) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                this.config.load(configURL);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void save(URL configURL) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                this.config.save(configURL);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setProperties(String key, List values) {
            Object object = this.mutex;
            synchronized (object) {
                this.config.setProperties(key, values);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setProperties(String key, Iterator values) {
            Object object = this.mutex;
            synchronized (object) {
                this.config.setProperties(key, values);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setProperty(String key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                this.config.setProperty(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Properties getProperties() {
            Object object = this.mutex;
            synchronized (object) {
                return this.config.getProperties();
            }
        }
    }
}

